## PowerCons
#
#The PowerCons dataset contains the individual household electric power consumption in one year distributed in two season classes:  warm (class 1) and cold (class 2), depending on whether the power consumption is recorded during the warm seasons (from April to September) or the cold seasons (from October to March). Note that the electric power consumption profiles differ markedly within classes. The sampling rate is every ten-minute over a period of one year.
#
#Train size: 180
#
#Test size: 180
#
#Time series length: 144
#
#Number of classes: 2
#- Class 1: Warm season 
#- Class 2: Cold season
#
#Missing value: No
#
#Source: EDF R&D, Clamart, France 
@problemName PowerCons
@timeStamps false
@missing false
@univariate true
@equalLength true
@seriesLength 144
@classLabel true 1 2
@data
0.44,0.4,0.36,0.35,0.35,0.38,0.36,0.35,0.35,0.38,0.38,0.38,0.42,0.45,0.43,0.37,0.66,1.13,1.35,1.09,0.75,0.41,0.37,0.33,0.33,0.4,0.4,0.39,0.4,0.43,0.4,0.35,0.31,0.33,0.33,0.33,0.3,0.3,0.33,0.36,1.1,1.83,1.93,2.04,2.04,1.93,1.93,1.53,1.36,1.19,2.25,3.31,3.08,2.85,2.04,1.24,1.26,1.29,1.31,1.34,1.79,2.25,1.73,1.21,1.12,0.97,0.82,0.47,0.11,0.16,0.22,0.62,0.82,0.63,0.35,0.3,0.22,0.17,0.27,0.21,0.15,0.16,0.22,0.31,0.48,0.65,1.01,1.36,0.92,0.52,0.23,0.21,0.19,0.16,0.16,0.17,0.17,0.17,0.18,0.18,0.16,0.19,0.25,0.28,0.26,0.23,0.21,0.2,0.18,0.14,0.25,0.37,0.58,0.7,0.74,0.56,0.38,0.32,0.3,0.32,0.31,0.31,0.85,1.4,1.82,2.24,2.29,2.34,2.38,2.38,1.23,1.23,1.18,1.14,0.77,0.4,0.33,0.29,0.28,0.24,0.22,0.23,0.25,0.25:1
0.14,0.19,0.19,0.16,0.16,0.18,0.17,0.16,0.17,0.17,0.16,0.18,0.18,0.14,0.13,0.16,0.19,0.14,0.15,0.18,0.18,0.15,0.16,0.19,0.17,0.16,0.16,0.17,0.16,0.18,0.17,0.14,0.15,0.17,0.18,0.1,0.37,0.64,0.89,1.14,1.19,1.24,0.68,0.12,0.16,0.17,0.16,0.18,0.16,0.14,0.15,0.16,0.16,0.13,0.16,0.14,0.12,0.14,0.17,0.18,0.16,0.16,0.16,0.16,0.17,0.22,0.25,0.25,0.27,0.29,0.17,0.13,0.17,0.18,0.16,0.15,0.16,0.16,0.16,0.18,0.16,0.14,0.16,0.18,0.16,0.13,0.17,0.14,0.1,0.13,0.17,0.18,0.16,0.16,0.16,0.16,0.16,0.18,0.15,0.15,0.18,0.2,0.18,0.2,0.22,0.21,0.2,0.22,0.71,1.2,1.21,1.26,1.33,1.41,1.48,1.15,0.83,0.62,0.4,0.37,0.32,0.26,0.23,0.25,0.24,0.23,0.23,0.25,0.25,0.21,0.22,0.26,0.29,0.39,0.48,0.62,0.39,0.17,0.14,0.7,1.25,1.21,1.2,1.24:1
0.34,0.34,0.34,0.26,0.18,0.83,1.48,1.36,0.95,0.55,0.42,0.29,0.26,0.24,0.24,0.25,0.23,0.25,0.26,0.25,0.25,0.26,0.28,0.3,0.33,0.31,0.3,0.27,0.25,0.22,0.2,0.22,0.24,0.22,0.19,0.22,0.24,0.24,0.25,1.79,3.33,2.94,2.54,2.54,1.58,1.58,1.46,1.34,1.61,1.79,1.96,1.97,1.63,1.29,1.31,1.34,1.32,1.3,1.28,1.26,1.24,1.21,0.92,0.64,0.45,0.26,0.23,0.24,0.26,0.25,0.25,0.29,0.34,0.33,0.33,0.31,0.29,0.32,0.35,0.31,0.27,0.23,0.2,1.29,2.39,0.77,0.75,0.74,1.08,1.42,1.37,1.58,1.79,1.04,0.29,0.35,0.32,0.28,0.3,0.32,0.19,0.17,0.16,0.24,0.32,0.32,0.32,0.32,0.28,0.28,0.26,0.25,0.26,0.27,0.24,0.21,0.21,0.21,0.23,0.24,0.93,1.62,2.12,2.63,2.63,1.18,1.18,1.01,0.83,0.78,0.74,0.72,0.71,0.7,0.84,0.97,1.23,1.49,1.17,0.85,0.83,0.79,0.75,0.73:1
1.7,1.5,1.3,3.4,5.5,4.15,2.8,2.67,2.53,2.49,2.45,2.41,1.64,0.88,0.53,0.19,0.17,0.16,0.16,0.22,0.29,0.19,0.14,0.15,0.21,0.26,0.26,0.22,0.21,0.24,0.26,0.29,0.22,0.17,0.13,0.19,0.24,0.16,0.13,0.17,0.21,0.26,0.3,0.99,1.67,1.52,1.36,1.38,1.38,1.39,1.41,1.38,1.35,1.34,1.33,1.33,1.31,1.3,0.89,0.49,0.31,0.14,0.2,0.23,0.22,0.23,0.28,0.31,0.3,0.28,0.34,0.41,0.34,0.27,0.3,0.3,0.29,0.27,0.62,0.97,0.97,1.31,1.31,1.34,1.38,1.41,1.43,1.46,1.43,1.41,1.04,0.66,0.47,0.28,0.26,0.27,0.27,0.23,0.24,0.26,0.28,0.3,0.33,0.65,0.98,0.75,0.51,0.64,0.48,0.31,1.46,2.6,1.44,0.27,0.35,0.44,0.46,0.47,0.48,1.01,1.54,1.75,1.97,1.89,1.81,1.67,1.54,1.49,1.43,1.41,1.43,1.44,1.53,1.61,1.62,1.61,1.6,1.59,1.55,1.0,0.55,0.37,0.37,0.36:1
1.78,1.59,1.39,1.45,1.45,1.41,1.4,1.45,1.46,1.4,0.85,0.3,0.34,0.38,0.33,0.33,0.39,0.35,0.31,0.31,0.35,0.38,0.38,0.33,0.33,0.38,0.39,0.35,0.33,0.36,0.38,0.37,0.34,0.34,0.37,0.37,0.35,0.35,0.37,0.38,0.36,0.35,0.36,0.36,0.36,0.35,0.37,0.37,0.35,0.34,0.36,0.38,0.37,0.39,0.41,1.08,1.75,1.68,1.66,1.65,1.5,1.34,1.55,1.75,1.68,1.6,1.48,1.41,1.38,1.33,1.31,1.34,1.39,1.4,1.39,1.38,1.14,0.89,0.56,0.22,0.27,0.29,0.27,0.27,0.29,0.28,0.27,0.27,0.3,0.3,0.31,0.33,0.36,0.38,0.35,0.3,0.3,0.31,0.3,0.25,0.26,0.31,0.32,0.27,0.24,0.26,0.27,0.28,0.29,0.33,0.39,0.37,0.31,0.27,0.28,0.29,0.29,0.24,0.25,0.3,0.3,0.26,0.25,0.28,0.31,0.3,0.31,0.34,0.36,0.35,0.32,0.31,0.32,0.84,1.36,1.36,1.4,0.81,0.23,0.27,0.29,0.28,0.27,0.27:1
0.41,0.3,0.24,0.28,0.28,0.28,0.23,0.25,0.31,0.31,0.26,0.24,0.3,0.35,0.36,0.33,0.33,0.37,0.36,0.29,0.27,0.29,0.31,0.28,0.26,0.28,0.29,0.29,0.27,0.28,0.3,0.33,0.34,0.35,0.36,0.35,0.33,0.3,0.3,0.29,0.27,0.26,0.29,0.3,0.27,0.26,0.28,0.31,0.3,0.3,0.33,0.38,0.37,0.32,0.3,0.31,0.31,0.28,0.23,0.25,0.29,0.31,0.25,0.24,0.29,0.27,0.26,0.28,0.62,1.11,1.41,1.36,1.32,1.32,0.78,0.24,0.23,0.26,0.31,0.31,0.25,0.24,0.29,0.34,0.62,1.11,0.87,0.5,0.47,0.43,0.38,1.35,2.32,2.28,2.24,1.88,1.51,1.49,0.98,0.47,0.42,0.37,0.31,0.25,0.22,0.23,0.22,0.18,0.17,0.22,0.27,0.3,0.27,0.23,0.21,0.21,0.19,0.2,0.22,0.26,0.24,0.2,0.18,0.19,0.21,0.21,0.22,0.24,0.26,0.24,0.2,1.71,3.22,2.24,1.27,1.59,1.91,1.65,1.4,1.11,0.81,0.6,0.39,0.32:1
1.66,1.58,1.5,0.99,0.48,0.52,0.53,0.51,0.46,0.41,0.45,0.49,0.44,0.45,0.56,0.71,0.6,0.48,0.49,0.49,0.49,0.5,0.51,0.5,0.5,0.33,0.16,0.16,0.19,0.17,0.16,0.16,0.18,0.2,0.17,0.17,0.17,0.17,0.17,0.19,0.18,0.16,0.13,0.7,1.26,1.23,1.23,1.22,1.18,1.15,1.15,1.19,1.21,1.22,1.21,1.2,1.21,1.28,1.9,2.53,2.05,1.56,1.37,1.17,1.18,1.22,1.3,1.38,1.62,1.85,1.53,1.22,1.28,1.28,1.2,2.27,3.34,2.23,1.13,1.16,1.2,1.21,1.18,1.17,1.18,1.2,1.22,1.25,1.23,1.22,1.22,1.22,1.22,1.2,1.22,1.3,0.72,0.14,0.2,0.22,0.21,0.21,0.21,0.2,0.21,0.23,0.23,0.18,0.21,0.26,0.21,0.16,0.18,0.22,0.24,0.21,0.2,0.2,0.21,0.21,0.23,0.22,0.17,0.23,0.29,0.24,0.19,0.18,0.24,0.23,0.2,0.19,0.21,0.22,0.21,0.22,0.2,0.2,0.21,0.26,0.29,1.02,1.75,1.95:1
1.36,1.11,0.85,0.74,0.63,0.53,0.48,0.39,0.28,0.17,0.15,0.19,0.38,0.57,0.89,1.21,1.16,1.07,0.94,0.52,0.1,0.14,0.19,0.19,0.15,0.15,0.17,0.17,0.16,0.17,0.16,0.15,0.17,0.19,0.16,0.13,0.16,0.15,0.14,0.13,0.17,0.19,0.17,0.16,0.16,0.16,0.16,0.19,0.42,0.65,1.03,1.41,1.41,1.78,2.16,2.62,2.22,1.82,1.79,1.76,1.71,1.65,2.29,2.92,2.09,1.26,1.23,1.19,1.18,1.21,1.22,1.17,1.16,1.21,1.21,1.17,1.16,1.21,1.21,1.18,1.15,0.89,0.48,0.16,0.17,0.17,0.16,0.17,0.18,0.16,0.16,0.18,0.19,0.14,0.15,0.2,0.19,0.14,0.14,0.2,0.2,0.15,0.15,0.19,0.19,0.16,0.16,0.18,0.18,0.17,0.18,0.16,0.16,0.18,0.19,0.15,0.15,0.19,0.19,0.15,0.14,0.19,0.19,0.15,0.14,0.18,0.19,0.16,0.18,0.26,1.59,2.91,2.92,2.92,2.6,2.6,2.89,3.17,3.95,4.73,5.76,5.76,3.09,3.09:1
2.04,1.92,1.81,1.72,1.52,1.32,0.98,0.65,0.46,0.27,0.28,0.32,0.36,0.33,0.29,0.29,0.28,0.22,0.15,0.16,0.17,0.17,0.18,0.2,0.18,0.17,0.17,0.18,0.15,0.13,0.15,0.17,0.16,0.14,0.17,0.2,0.18,0.16,0.16,0.16,0.17,0.19,0.22,0.25,0.31,0.36,0.88,1.4,1.37,1.6,1.84,2.51,3.17,2.59,2.0,1.98,1.77,1.56,1.46,1.47,1.48,1.45,1.38,1.31,2.01,2.72,2.83,2.95,2.09,1.23,1.23,1.25,1.25,1.23,1.21,1.26,1.3,1.27,1.25,1.25,0.19,0.19,0.23,0.26,0.26,0.22,0.18,0.18,0.17,0.18,0.18,0.18,0.18,0.18,0.19,0.2,0.16,0.12,0.16,0.2,0.16,0.13,0.18,0.23,0.19,0.15,0.17,0.19,0.18,0.17,0.2,0.19,0.18,0.19,0.2,0.17,0.14,0.16,0.18,0.16,0.13,0.17,0.2,0.18,0.15,0.18,0.22,0.19,0.17,0.17,0.17,0.17,0.19,0.2,0.18,0.17,0.18,0.18,0.11,0.64,1.18,1.99,2.8,2.67:1
0.44,0.39,0.34,0.4,0.37,0.35,0.36,0.37,0.43,0.42,0.41,0.44,0.47,0.45,0.42,0.41,0.4,0.4,0.34,0.34,0.39,0.43,0.4,0.37,0.36,0.4,0.44,0.45,0.46,0.41,0.35,0.36,0.36,0.36,0.37,0.35,0.34,0.42,1.48,2.54,2.27,2.01,1.8,1.6,1.72,1.85,1.95,1.67,1.38,1.3,1.21,1.21,1.15,1.15,0.72,0.3,0.3,0.26,0.24,0.24,0.21,0.19,0.19,0.19,0.19,0.2,0.2,0.21,0.22,0.22,0.27,0.27,0.64,1.01,0.63,0.25,0.31,0.3,0.29,0.25,0.2,0.31,0.42,0.33,0.23,0.37,0.32,0.27,0.27,0.2,0.31,0.31,0.49,0.67,0.88,1.08,1.21,1.04,0.87,0.56,0.26,0.26,0.27,0.27,0.23,0.2,0.21,0.19,0.16,0.23,0.3,0.3,0.3,0.2,0.45,0.69,0.61,0.53,0.48,0.42,0.4,0.37,0.77,1.17,1.36,1.55,1.94,2.33,2.24,1.88,1.52,1.41,1.31,1.22,1.28,1.35,1.32,1.38,1.44,1.43,1.42,1.43,2.09,2.75:1
0.26,0.24,0.22,0.17,0.16,0.18,0.2,0.2,0.22,0.26,0.27,0.22,0.19,0.2,0.19,0.16,0.15,0.19,0.19,0.16,0.15,0.2,0.22,0.22,0.24,0.27,0.24,0.19,0.17,0.19,0.17,0.15,0.18,0.19,0.16,0.16,0.22,0.34,0.76,1.18,1.56,1.94,1.41,0.89,0.88,0.88,0.63,0.38,0.28,0.2,0.16,0.17,0.24,0.25,0.23,0.23,0.23,0.18,0.16,0.16,0.18,0.16,0.16,0.17,0.18,0.16,0.16,0.2,0.25,0.23,0.22,0.2,0.18,0.16,0.17,0.17,0.16,0.17,0.22,0.32,0.42,0.5,0.55,0.52,0.44,0.39,0.35,0.27,0.18,0.15,0.19,0.22,0.22,0.78,1.34,1.34,1.3,1.3,1.34,1.32,1.24,1.22,1.26,1.28,0.71,0.14,0.21,0.2,0.18,0.2,0.28,0.32,0.31,0.3,0.28,0.24,0.2,0.2,0.22,0.43,0.63,0.63,0.64,1.03,1.43,1.84,2.25,2.25,2.29,2.57,2.84,3.62,4.4,3.64,2.87,3.38,3.88,3.3,2.29,1.29,1.36,1.38,1.34,1.3:1
0.38,0.29,0.23,0.24,0.28,0.28,0.24,0.22,0.28,0.26,0.23,0.21,0.24,0.28,0.28,0.24,0.24,0.31,0.27,0.23,0.21,0.23,0.26,0.28,0.24,0.26,0.3,0.3,0.25,0.22,0.24,0.27,0.27,0.25,0.27,0.3,0.29,0.24,0.23,0.25,0.27,0.27,0.28,0.28,0.29,0.27,0.25,0.23,0.24,0.26,0.26,0.23,0.22,0.21,0.46,0.7,0.97,1.25,1.29,1.32,1.33,0.77,0.21,0.25,0.26,0.23,0.23,0.25,0.29,0.29,0.25,0.25,0.28,0.29,0.66,1.01,1.15,1.64,2.12,2.06,3.55,5.04,3.9,2.75,2.1,1.45,1.39,1.33,1.3,1.34,1.35,1.33,1.32,1.36,1.39,1.39,1.0,0.61,0.46,0.31,0.28,0.28,0.28,0.28,0.26,0.24,0.22,0.25,0.28,0.29,0.26,0.25,0.26,0.25,0.24,0.22,0.2,0.25,0.3,0.25,0.24,0.26,0.26,0.25,0.23,0.23,0.24,0.25,0.24,0.24,0.26,0.27,0.25,0.25,0.29,0.3,0.28,0.24,0.24,0.26,0.28,0.27,0.26,0.27:1
0.21,0.23,0.22,0.21,0.24,0.27,0.26,0.24,0.19,0.23,0.26,0.24,0.22,0.25,0.22,0.19,0.19,0.19,0.19,0.19,0.21,0.23,0.25,0.28,0.31,0.3,0.28,0.25,0.2,0.14,0.17,0.19,0.19,0.19,0.19,0.23,0.26,0.2,0.2,0.2,0.34,1.2,2.07,2.01,1.93,1.86,1.85,1.83,1.79,2.2,2.61,2.61,1.37,1.37,1.27,1.92,2.56,1.94,1.32,1.25,1.19,1.2,1.2,1.19,1.14,1.08,0.64,0.2,0.2,0.21,0.26,0.22,0.17,0.17,0.16,0.18,0.21,0.24,0.27,0.28,0.28,0.28,0.3,0.23,0.16,0.16,0.16,0.16,0.18,0.19,0.19,0.21,0.22,0.23,0.22,0.22,0.22,0.23,0.24,0.21,0.21,0.22,0.22,0.21,0.2,0.2,0.28,0.32,0.36,0.31,0.26,0.31,0.36,0.54,0.72,0.96,1.21,0.91,0.61,0.38,0.14,0.2,0.2,0.19,0.2,0.21,0.23,0.24,0.22,0.26,0.31,0.33,0.38,0.43,0.43,0.26,0.26,0.25,0.23,0.23,0.22,0.22,0.22,0.22:1
1.98,2.13,2.28,1.97,1.8,1.68,1.66,1.63,1.57,1.45,1.35,1.26,1.23,1.2,0.89,0.58,0.4,0.22,0.22,0.19,0.2,0.23,0.22,0.19,0.17,0.22,0.18,0.15,0.17,0.21,0.22,0.2,0.19,0.2,0.21,0.2,0.21,0.2,0.19,0.19,0.22,0.21,0.14,0.2,0.26,0.2,0.15,0.14,0.2,0.25,0.32,0.39,0.65,0.91,1.16,1.4,1.44,1.38,1.32,1.35,1.35,3.72,3.72,3.72,2.37,2.37,2.59,2.56,2.53,2.31,2.32,2.34,1.79,1.25,1.27,1.29,1.31,1.26,1.25,1.25,1.25,1.22,1.22,1.23,1.24,1.24,1.25,1.24,1.24,1.24,1.27,1.26,1.24,1.24,0.96,0.67,0.41,0.14,0.16,0.19,0.15,0.17,0.2,0.2,0.19,0.18,0.19,0.18,0.17,0.18,0.18,0.17,0.18,0.2,0.17,0.16,0.18,0.17,0.17,0.14,0.14,0.16,0.18,0.15,0.17,0.2,0.19,0.18,0.17,0.18,0.17,0.17,0.18,0.18,0.18,0.19,0.2,0.17,0.15,0.16,0.16,2.13,2.13,2.3:1
0.91,0.87,0.84,0.82,0.9,0.98,0.78,0.58,0.6,0.62,0.51,0.4,0.4,0.41,0.39,0.35,0.32,0.29,0.26,0.41,0.55,0.52,0.49,0.51,0.52,0.52,0.45,0.52,0.58,0.57,0.57,0.39,0.21,0.45,0.7,0.93,1.17,0.78,0.52,0.25,0.21,0.2,0.19,0.29,0.28,0.27,0.26,0.24,0.23,0.21,0.19,0.56,0.93,0.74,0.55,0.43,0.87,1.31,1.34,1.37,1.34,1.32,1.2,1.07,0.62,0.17,0.54,0.95,1.35,1.46,1.46,5.79,5.79,5.07,4.35,4.41,4.47,3.45,2.43,2.04,1.64,1.68,1.73,1.77,1.77,1.77,2.2,2.62,2.06,1.9,1.73,1.51,2.12,2.73,2.05,1.37,1.05,0.73,0.55,0.37,0.37,0.37,0.5,0.62,0.67,0.72,0.96,1.19,1.0,0.81,0.83,0.84,0.71,0.57,0.58,0.75,0.92,0.99,1.07,1.19,1.51,1.82,1.82,1.77,1.72,1.69,1.66,2.1,2.55,2.08,1.6,1.6,2.52,2.52,2.0,1.48,1.6,1.77,1.93,1.58,1.22,1.22,1.11,1.11:1
0.32,0.3,0.28,0.24,0.26,0.3,0.32,0.26,0.24,0.3,0.27,0.24,0.23,0.25,0.32,0.38,0.32,0.33,0.37,0.36,0.29,0.23,0.28,0.27,0.26,0.24,0.27,0.31,0.3,0.25,0.25,0.31,0.38,0.87,1.35,1.15,0.96,0.59,0.22,0.26,0.29,0.29,0.25,0.26,0.28,0.3,0.27,0.27,0.28,0.31,0.32,0.34,0.35,0.35,0.33,0.29,0.29,0.28,0.28,0.26,0.27,0.29,0.28,0.27,0.27,0.29,0.31,0.32,0.34,0.36,0.36,0.34,0.31,0.3,0.3,0.28,0.26,0.27,0.3,0.29,0.26,0.26,0.29,0.3,0.27,0.28,0.34,0.38,0.37,0.31,0.31,0.33,0.31,0.26,0.22,0.63,1.05,1.17,1.28,1.12,0.95,0.59,0.22,0.28,0.4,0.57,0.6,0.63,0.57,0.54,0.54,0.53,0.53,0.82,0.63,0.44,0.43,0.45,0.49,1.08,1.68,1.27,0.86,0.97,1.02,1.02,1.02,1.02,1.01,1.02,1.04,1.02,1.01,1.01,1.04,1.1,1.2,1.51,1.81,1.8,1.79,1.77,1.79,1.84:1
0.38,0.39,0.39,0.38,0.46,0.4,0.35,0.36,0.38,0.33,0.28,0.32,0.37,0.32,0.28,0.32,0.36,0.37,0.38,0.4,0.42,0.38,0.34,0.33,0.33,0.33,0.33,0.32,0.31,0.85,1.39,1.22,1.06,0.74,0.43,0.42,0.41,0.42,0.94,1.45,1.86,2.28,2.13,1.99,1.95,1.91,1.87,1.87,1.87,1.87,1.86,1.85,1.84,1.74,1.47,1.19,1.19,1.2,1.21,1.2,1.18,1.2,1.23,1.06,0.9,0.59,0.27,0.23,0.19,0.19,0.19,0.19,0.2,0.19,0.17,0.19,0.21,0.22,0.22,0.26,0.3,0.25,0.21,0.23,0.19,0.15,0.18,0.22,0.19,0.16,0.18,0.2,0.21,0.23,0.24,0.25,0.26,0.27,0.22,0.16,0.23,0.24,0.25,0.2,0.15,0.18,0.22,0.23,0.23,0.26,0.29,0.26,0.22,0.18,0.26,0.34,0.35,0.37,1.21,2.06,2.32,2.59,2.18,1.78,1.83,1.78,1.74,3.86,2.52,1.18,1.76,2.33,1.72,1.1,1.07,1.07,1.0,0.99,0.99,0.94,0.89,0.93,0.97,0.97:1
0.35,0.35,0.35,0.35,0.39,0.39,0.35,0.32,0.34,0.35,0.37,0.36,0.35,0.35,0.38,0.38,0.34,0.29,0.29,0.3,0.32,0.35,0.32,0.34,0.36,0.31,0.26,0.26,0.26,0.32,0.38,0.31,0.24,0.24,0.3,0.3,0.32,0.34,0.34,0.34,1.54,2.74,2.21,1.69,1.71,1.73,1.31,0.89,1.54,2.2,1.95,1.7,1.79,1.8,1.82,1.54,1.44,1.35,1.44,1.39,1.33,1.33,1.34,1.34,1.34,1.13,0.77,0.42,0.42,0.36,0.36,0.94,1.51,1.81,1.81,1.49,1.49,1.4,0.93,0.46,0.46,0.33,0.3,0.47,0.47,0.55,0.63,0.49,0.36,0.33,0.32,0.31,0.28,0.32,0.36,0.33,0.33,0.32,0.31,0.3,0.3,0.37,0.37,0.59,0.82,1.09,1.36,1.02,0.68,0.33,0.35,0.37,0.35,0.32,0.63,0.94,1.57,2.19,2.31,2.42,2.33,2.23,2.11,1.99,2.4,2.7,3.01,3.79,4.57,3.71,2.85,2.91,2.97,2.62,2.28,2.76,3.25,2.31,1.38,1.4,1.42,1.41,1.4,1.31:1
0.11,0.16,0.16,0.15,0.14,0.17,0.18,0.17,0.14,0.17,0.19,0.17,0.15,0.16,0.19,0.17,0.16,0.17,0.19,0.17,0.16,0.16,0.19,0.17,0.16,0.16,0.19,0.17,0.16,0.16,0.18,0.19,0.21,0.23,0.26,0.25,0.27,0.31,0.93,1.55,3.39,2.65,1.91,1.93,1.98,2.05,2.13,1.81,1.54,1.26,1.26,1.27,1.27,1.25,1.26,1.27,1.29,1.25,1.23,0.84,0.45,0.22,0.22,0.23,0.24,0.22,0.22,0.23,0.24,0.22,0.22,0.24,0.24,0.22,0.22,0.24,0.24,0.22,0.22,0.24,0.23,0.23,0.22,0.24,0.23,0.22,0.22,0.24,0.24,0.22,0.22,0.25,1.49,2.72,2.5,2.28,2.24,2.2,1.84,1.48,1.48,3.46,3.46,3.3,3.15,3.15,1.37,1.37,1.22,1.07,0.68,0.3,0.35,0.35,0.49,0.63,0.75,1.44,2.14,2.0,1.87,1.84,3.03,4.22,4.93,5.64,4.35,3.07,2.64,2.2,2.2,0.65,0.65,0.46,0.32,0.26,0.24,0.22,0.18,0.16,0.16,0.18,0.19,0.17:1
0.24,0.25,0.28,0.31,0.27,0.23,0.21,0.22,0.23,0.16,0.16,0.19,0.2,0.15,0.16,0.19,0.21,0.2,0.21,0.28,0.28,0.22,0.19,0.2,0.19,0.17,0.15,0.18,0.17,0.15,0.14,0.16,0.2,0.23,0.22,0.22,0.19,0.16,0.13,0.13,0.89,1.65,1.79,1.91,1.99,1.51,1.04,2.22,3.4,2.44,1.48,1.38,1.27,0.99,0.71,0.46,0.21,0.18,0.15,0.16,0.2,0.24,0.23,0.2,0.18,0.16,0.16,0.17,0.17,0.17,0.15,0.17,0.17,0.17,0.18,0.23,0.31,0.94,1.56,1.45,1.06,0.7,0.4,0.42,0.43,0.41,0.56,0.72,0.75,0.75,0.76,0.79,0.82,0.82,0.72,0.63,0.67,0.67,0.63,0.64,0.67,0.68,0.62,0.66,0.72,0.75,0.74,0.75,0.81,0.66,0.51,0.45,0.39,0.38,0.35,0.3,0.52,0.75,0.99,1.24,2.12,3.0,2.59,2.18,2.2,2.23,4.16,6.1,4.83,3.56,3.56,1.53,1.53,1.98,2.43,2.43,0.64,0.64,0.49,0.34,0.36,0.35,0.32,0.31:1
1.44,1.41,1.27,1.12,0.78,0.44,0.35,0.28,0.26,0.27,0.32,0.32,0.29,0.31,0.36,0.37,0.31,0.26,0.27,0.3,0.3,0.25,0.25,0.31,0.31,0.27,0.24,0.27,0.32,0.37,0.27,0.24,0.28,0.27,0.26,0.23,0.26,0.31,0.31,0.27,0.26,1.22,1.97,1.9,1.54,1.96,2.46,2.56,2.67,1.98,1.98,1.93,1.93,1.79,1.66,1.7,1.72,1.69,1.62,1.59,1.56,1.56,1.55,1.53,1.52,1.56,1.29,1.02,1.27,1.52,1.54,1.53,1.49,1.46,1.41,1.42,1.45,1.47,1.45,1.54,1.62,1.52,1.43,1.41,1.41,1.4,1.4,1.34,1.35,1.41,1.42,1.37,1.33,1.38,1.4,1.41,1.36,1.39,1.47,1.45,1.38,1.33,1.37,0.99,0.6,0.43,0.26,0.33,0.33,0.28,0.28,0.35,0.39,0.36,0.3,0.29,0.31,0.31,0.27,0.27,0.31,0.32,0.29,0.27,0.3,0.35,0.36,0.34,0.32,0.31,0.31,0.29,0.28,0.3,0.32,0.29,0.45,0.6,0.71,0.81,0.84,0.86,0.83,0.8:1
0.43,0.33,0.3,0.34,0.36,0.34,0.29,0.29,0.34,0.39,0.39,0.35,0.33,0.35,0.34,0.32,0.28,0.29,0.35,0.35,0.34,0.33,0.36,0.39,0.37,0.32,0.28,0.3,0.35,0.35,0.32,0.29,0.34,0.42,0.4,0.33,0.28,0.3,0.35,0.38,0.96,1.55,1.09,0.63,1.18,1.51,1.84,1.64,1.44,1.39,1.33,1.3,1.32,1.37,1.38,1.36,1.34,1.35,1.37,1.35,1.32,1.3,1.33,1.37,1.36,1.32,1.28,1.06,0.71,0.4,0.33,0.29,0.33,0.36,0.35,0.31,0.3,0.35,0.41,0.42,0.37,0.34,0.34,0.36,0.34,0.31,0.31,0.34,0.36,0.36,0.37,0.38,0.38,0.37,0.34,0.31,0.32,0.34,0.35,0.33,0.32,0.36,0.4,0.41,0.36,0.32,0.33,0.34,0.35,0.34,0.36,0.98,1.61,1.51,1.42,1.33,0.83,0.33,0.31,0.29,0.32,0.35,0.42,0.48,0.54,0.58,0.57,0.55,0.52,0.51,0.5,0.66,0.82,0.71,0.6,0.86,1.12,0.83,0.55,0.87,1.15,1.34,1.37,1.29:1
0.19,0.24,0.26,0.23,0.21,0.2,0.21,0.2,0.17,0.18,0.22,0.26,0.24,0.18,0.17,0.19,0.21,0.18,0.17,0.19,0.24,0.26,0.21,0.19,0.19,0.46,0.72,0.95,1.17,1.27,0.75,0.22,0.18,0.18,0.19,0.2,0.18,0.17,0.2,0.23,0.25,1.96,3.67,2.51,1.36,1.27,1.32,1.37,1.34,0.77,0.2,0.2,0.21,0.21,0.18,0.14,0.17,0.21,0.25,0.21,0.18,0.17,0.18,0.19,0.14,0.15,0.21,0.23,0.22,0.21,0.24,0.27,0.22,0.16,0.15,0.2,0.25,0.3,0.3,0.3,0.32,0.3,0.26,0.25,0.29,0.45,0.61,0.43,0.38,0.32,0.31,0.28,0.26,0.28,0.36,0.79,1.16,1.3,0.99,0.68,0.5,0.33,0.33,0.34,0.27,0.26,0.28,0.31,0.3,0.29,0.32,0.35,0.35,0.27,0.28,0.31,0.37,0.36,0.36,0.5,0.5,0.51,0.36,0.22,1.36,2.51,2.1,2.83,3.56,3.06,2.51,1.93,1.71,1.5,2.13,2.43,1.68,0.73,0.32,0.29,0.25,0.24,0.22,0.2:1
1.31,0.87,0.62,0.38,0.33,0.3,0.28,0.28,0.28,0.27,0.25,0.26,0.27,0.29,0.31,0.31,0.31,0.3,0.28,0.26,0.25,0.26,0.27,0.28,0.27,0.26,0.3,0.34,0.33,0.29,0.25,0.26,0.27,0.27,0.26,0.25,0.27,0.32,1.2,2.07,1.75,1.43,1.49,1.56,1.66,1.71,1.76,1.76,1.71,1.62,1.99,2.37,2.37,1.28,1.28,1.86,2.43,1.87,1.3,1.27,1.28,2.55,3.83,2.63,1.44,1.39,1.37,1.38,1.37,1.36,1.35,1.37,1.44,1.59,2.31,3.04,3.04,3.34,3.34,2.89,2.44,2.38,2.34,2.2,2.05,1.24,0.42,0.48,0.52,0.51,0.46,0.46,0.48,0.5,0.39,0.29,0.34,0.39,0.36,0.28,0.68,1.07,1.29,1.39,1.38,1.31,1.21,0.78,0.35,0.91,1.47,1.62,1.77,1.74,1.56,1.37,1.0,0.63,0.64,0.65,1.01,1.37,1.38,1.69,2.01,2.08,2.12,2.0,1.81,1.81,1.82,1.82,1.25,0.69,1.12,1.55,1.95,2.35,1.75,0.96,0.25,0.25,0.31,0.4:1
0.12,0.23,0.2,0.17,0.14,0.15,0.21,0.25,0.29,0.24,0.23,0.23,0.25,0.27,0.27,0.26,0.24,0.21,0.22,0.25,0.25,0.19,0.14,0.12,0.13,0.19,0.25,0.17,0.13,0.15,0.2,0.23,0.2,0.17,0.16,0.73,1.3,1.33,1.33,1.01,0.69,0.47,0.25,0.29,0.26,0.23,0.19,0.21,0.25,0.21,0.17,0.13,0.13,0.18,0.21,0.21,0.16,0.15,0.16,0.19,0.2,0.21,0.2,0.2,0.21,0.24,0.28,0.28,0.25,0.5,0.77,0.63,0.36,0.3,0.24,0.21,0.23,0.24,0.22,0.19,0.17,0.16,0.17,0.18,0.21,0.21,0.18,0.14,0.14,0.2,0.2,0.21,0.2,0.2,0.23,0.26,0.29,0.24,0.23,0.23,0.27,0.33,0.88,1.43,1.36,1.33,1.34,1.34,1.34,1.31,1.27,0.73,0.19,0.26,0.25,0.22,0.16,0.15,0.19,0.23,0.27,0.23,0.22,0.26,0.3,0.32,0.28,0.25,0.25,0.26,0.28,0.29,0.29,0.26,0.22,0.21,0.22,0.25,0.23,0.17,0.14,0.14,0.2,0.27:1
0.19,0.22,0.25,0.19,0.14,0.11,0.2,0.28,0.23,0.19,0.2,0.21,0.2,0.18,0.18,0.19,0.19,0.18,0.16,0.14,0.12,0.17,0.22,0.22,0.24,0.24,0.28,0.2,0.12,0.56,1.0,1.11,1.22,0.71,0.2,0.2,0.2,0.17,0.14,0.17,0.2,1.26,2.33,1.32,0.32,0.72,1.1,1.47,1.4,1.34,1.37,1.38,1.39,1.39,1.42,1.42,1.46,1.42,1.38,1.31,0.98,0.65,0.49,0.32,0.38,0.44,0.4,0.36,0.35,0.44,0.53,0.4,0.27,0.25,0.28,0.31,0.25,0.19,0.19,0.19,0.35,0.35,0.35,0.35,0.35,0.42,0.48,0.44,0.4,0.39,0.41,0.44,0.38,0.32,0.39,0.39,0.39,0.31,0.24,0.82,1.39,1.3,1.21,1.23,1.26,1.3,1.31,1.31,1.29,0.97,0.65,0.44,0.23,0.21,0.2,0.33,0.46,0.41,0.35,0.27,0.19,0.21,0.23,0.55,0.88,0.6,0.32,1.5,2.68,2.38,2.08,2.72,1.86,1.0,0.97,0.95,0.98,1.0,0.7,0.4,0.86,1.33,1.29,1.24:1
0.23,0.26,0.74,1.22,1.56,1.89,1.78,1.67,1.48,1.28,1.2,1.16,1.21,0.89,0.57,0.35,0.13,0.18,0.21,0.2,0.18,0.18,0.18,0.17,0.18,0.21,0.2,0.16,0.16,0.19,0.23,0.2,0.16,0.15,0.2,0.21,0.18,0.16,0.18,0.19,0.19,0.21,0.26,1.04,1.83,1.79,1.59,1.39,1.32,1.29,1.28,2.15,3.02,2.64,2.27,2.25,2.23,2.19,2.17,2.11,1.99,2.15,2.3,1.8,1.29,1.3,1.32,1.33,1.3,1.26,1.67,2.08,1.64,1.2,1.24,1.27,1.25,1.21,1.2,1.21,1.22,0.69,0.15,0.23,0.24,0.23,0.24,0.27,0.26,0.2,0.17,0.23,0.24,0.22,0.21,0.22,0.21,0.21,0.23,0.25,0.22,0.18,0.2,0.25,0.26,0.21,0.18,0.23,0.24,0.22,0.2,0.21,0.21,0.22,0.23,0.22,0.19,0.21,0.25,0.25,0.2,0.17,0.21,0.23,0.23,0.22,0.2,0.23,0.22,0.21,0.21,0.21,0.2,0.21,0.24,0.22,0.18,0.17,0.21,0.25,1.17,2.1,2.1,2.1:1
0.53,0.49,0.46,0.62,0.77,1.04,1.31,1.35,0.8,0.26,0.21,0.2,0.22,0.21,0.19,0.19,0.2,0.22,0.26,0.3,0.24,0.21,0.24,0.28,0.3,0.29,0.26,0.24,0.24,0.23,0.22,0.2,0.18,0.16,0.19,0.21,0.22,0.2,0.17,0.12,1.15,2.18,1.69,1.2,1.55,1.63,1.7,1.56,1.39,1.32,1.25,1.28,1.32,1.3,1.28,1.21,1.16,0.98,0.81,0.48,0.16,0.17,0.2,0.21,0.23,0.21,0.19,0.16,0.16,0.18,0.25,0.24,0.23,0.21,0.23,0.28,0.27,0.25,0.21,0.21,0.22,0.23,0.23,0.16,0.15,0.17,0.2,0.21,0.2,0.2,0.19,0.18,0.19,0.2,0.2,0.19,0.19,0.22,0.27,0.3,0.27,0.23,0.21,0.25,0.32,0.26,0.2,0.19,0.21,0.23,0.74,1.25,1.21,1.21,0.51,0.51,0.49,0.48,0.48,0.37,0.26,0.31,0.37,0.48,0.61,0.73,0.84,0.88,0.73,0.58,0.54,1.34,2.15,2.15,4.6,4.6,3.4,2.2,2.18,1.68,1.19,1.62,2.05,1.28:1
0.38,0.32,0.29,0.3,0.3,0.27,0.23,0.22,0.26,0.31,0.24,0.24,0.29,0.28,0.27,0.29,0.34,0.38,0.38,0.31,0.28,0.3,0.28,0.25,0.23,0.27,0.31,0.31,0.25,0.25,0.29,0.32,0.31,0.32,0.35,0.37,0.36,0.32,0.29,0.29,0.29,0.27,0.27,0.28,0.29,0.27,0.26,0.28,0.28,0.29,0.3,0.35,0.37,0.35,0.33,0.33,0.32,0.28,0.26,0.26,0.29,0.31,0.78,1.24,1.32,1.34,1.31,1.31,0.43,0.43,0.37,0.31,0.31,0.34,0.33,0.26,0.23,0.24,0.26,0.29,0.24,0.25,0.32,0.3,0.25,0.25,0.34,0.37,0.36,0.31,0.31,0.35,0.33,0.26,0.24,0.28,0.31,0.28,0.25,0.26,0.29,0.29,0.26,0.31,0.35,0.37,0.35,0.34,0.34,0.32,0.29,0.27,0.29,0.28,0.27,0.26,0.28,0.3,0.28,0.26,0.29,0.35,0.36,0.34,0.33,0.36,0.36,0.3,0.25,0.28,0.31,0.3,0.24,0.26,0.31,0.36,0.73,1.1,1.33,1.38,1.43,1.16,0.9,0.43:1
1.57,1.4,1.26,0.72,0.18,0.21,0.19,0.17,0.16,0.18,0.17,0.17,0.17,0.17,0.16,0.18,0.18,0.16,0.16,0.2,0.19,0.15,0.14,0.19,0.15,0.11,0.14,0.18,0.19,0.16,0.15,0.16,0.17,0.17,0.18,0.16,0.14,0.13,0.15,0.17,0.13,0.13,0.16,0.19,0.18,0.19,0.25,0.31,0.56,0.81,0.81,2.33,2.33,1.99,1.66,1.56,1.47,1.39,1.33,1.7,2.06,3.27,4.49,2.97,1.46,1.33,1.26,1.19,1.24,1.23,1.2,1.2,1.23,1.22,1.21,1.22,1.22,1.21,1.21,1.22,1.2,1.15,0.71,0.26,0.19,0.18,0.23,0.2,0.16,0.17,0.22,0.2,0.18,0.19,0.21,0.23,0.21,0.21,0.2,0.2,0.21,0.23,0.22,0.18,0.18,0.21,0.24,0.18,0.19,0.24,0.25,0.2,0.18,0.23,0.23,0.21,0.2,0.21,0.21,0.21,0.23,0.21,0.19,0.2,0.23,0.22,0.18,0.17,0.19,0.22,0.18,0.2,0.24,0.24,0.8,1.36,1.91,2.45,2.13,1.85,1.63,1.76,1.9,2.38:1
0.3,0.28,0.28,0.3,0.28,0.25,0.23,0.29,0.35,0.29,0.31,0.34,0.32,0.3,0.3,0.29,0.29,0.27,0.28,0.28,0.29,0.28,0.32,0.33,0.32,0.31,0.29,0.27,0.23,0.22,0.25,0.28,0.24,0.26,0.29,0.29,0.26,0.29,0.35,0.4,1.82,3.25,2.27,1.3,1.66,1.94,2.15,1.88,1.6,1.32,1.03,0.79,0.55,0.64,0.66,0.63,0.61,0.48,0.34,0.34,0.36,0.4,0.5,0.61,0.63,0.62,0.56,0.61,0.66,0.63,0.63,0.66,0.66,0.64,0.57,0.46,0.35,0.31,0.29,0.3,0.3,0.29,0.35,0.48,0.62,0.76,0.8,0.75,0.71,0.68,0.61,0.48,0.36,0.32,0.31,0.38,0.66,0.94,1.5,1.51,1.52,1.46,1.41,1.37,1.32,1.48,1.65,1.79,1.87,1.9,2.03,2.15,2.3,2.44,2.44,3.04,3.04,2.13,1.23,1.2,1.17,1.18,1.19,1.55,1.91,2.74,3.57,3.97,4.38,3.69,2.99,2.28,1.62,0.96,0.83,0.7,0.68,1.03,1.37,1.41,1.44,1.46,0.89,0.32:2
1.36,1.36,0.26,0.26,0.25,0.23,0.2,0.21,0.21,0.17,0.14,0.16,0.19,0.17,0.14,0.16,0.19,0.18,0.16,0.19,0.25,0.26,0.22,0.21,0.21,0.18,0.15,0.16,0.17,0.18,0.15,0.16,0.17,0.18,0.17,0.22,0.27,0.87,1.46,1.87,2.29,2.26,2.23,2.09,1.95,2.03,1.72,1.41,1.3,1.22,1.19,1.2,1.23,1.24,1.26,1.27,1.27,1.23,1.2,1.19,1.21,1.22,0.69,0.15,0.18,0.17,0.14,0.15,0.2,0.23,0.22,0.22,0.26,0.24,0.17,0.15,0.19,0.19,0.15,0.14,0.18,0.19,0.16,0.13,0.17,0.18,0.18,0.19,0.21,0.22,0.23,0.17,0.16,0.18,0.19,0.13,0.15,0.2,0.19,0.14,0.14,0.18,0.19,0.18,0.2,0.25,0.27,0.23,0.2,0.19,0.18,0.16,0.46,1.5,2.9,3.36,3.4,3.86,4.45,3.61,2.78,3.21,3.64,3.18,2.68,2.39,2.1,2.16,2.21,2.76,3.31,2.62,2.3,1.98,3.12,1.72,0.31,0.3,0.33,0.35,0.33,0.29,0.3,0.35:2
0.41,0.6,0.8,1.17,1.26,1.35,1.34,1.33,0.94,0.56,0.56,0.29,0.29,0.29,0.3,0.31,0.3,0.3,0.25,0.25,0.25,0.25,0.35,0.3,0.3,0.29,0.27,0.28,0.27,0.26,0.26,0.27,0.33,0.3,0.29,0.3,0.3,0.28,0.26,0.25,0.23,0.28,0.33,0.84,1.34,1.66,1.97,2.34,2.71,2.77,2.84,2.76,2.75,2.74,2.19,1.64,1.51,1.37,1.46,1.56,1.43,1.3,2.71,4.12,3.74,3.36,3.45,3.45,3.07,3.07,3.15,2.64,2.12,2.04,1.7,1.36,1.05,0.73,0.65,0.56,1.14,1.73,1.85,1.98,2.79,3.61,3.5,3.39,3.39,1.41,1.41,1.41,1.46,1.46,1.45,1.51,1.58,1.81,2.04,2.48,2.92,2.64,3.07,3.5,3.88,4.74,5.6,6.17,4.87,3.57,3.42,3.53,3.64,3.64,3.26,2.88,2.88,2.88,2.88,4.2,4.2,3.8,3.4,3.24,3.08,3.06,2.89,2.72,2.72,1.83,1.83,2.08,2.08,1.66,1.66,1.6,1.39,1.18,1.32,1.46,1.69,1.91,2.06,2.21:2
0.12,0.16,0.21,0.26,0.24,0.19,0.15,0.16,0.17,0.19,0.19,0.2,0.21,0.21,0.2,0.2,0.19,0.16,0.14,0.15,0.19,0.23,0.23,0.2,0.18,0.19,0.22,0.19,0.14,0.12,0.16,0.24,0.22,0.2,0.14,0.18,0.22,0.19,0.16,0.12,0.1,1.38,2.66,2.02,1.38,1.37,1.38,1.39,1.4,1.29,1.22,1.26,1.3,1.31,1.28,1.23,1.19,1.2,1.24,1.26,1.23,0.89,0.54,0.4,0.26,0.22,0.16,0.13,0.15,0.22,0.2,0.17,0.19,0.2,0.23,0.24,0.21,0.15,0.12,0.17,0.23,0.25,0.23,0.19,0.2,0.22,0.21,0.19,0.14,0.13,0.18,0.29,0.25,0.2,0.14,0.16,0.22,0.22,0.19,0.14,0.14,0.19,0.26,0.34,0.23,0.11,0.11,0.11,1.36,1.36,1.36,1.36,1.36,4.01,4.01,3.76,3.36,2.95,2.94,2.93,4.38,3.38,2.39,1.65,1.44,1.23,1.2,1.16,1.02,0.88,0.88,1.02,1.16,1.19,1.21,1.4,1.59,1.48,1.38,3.53,5.68,4.39,3.1,2.98:2
0.23,0.29,0.32,0.26,0.27,0.33,0.34,0.3,0.26,0.26,0.29,0.3,0.3,0.3,0.31,0.3,0.3,0.28,0.25,0.27,0.33,0.32,0.3,0.25,0.27,0.31,0.3,0.26,0.27,0.35,0.34,0.27,0.23,0.23,0.28,0.32,0.3,0.29,0.32,0.3,0.28,0.22,0.6,0.98,1.25,1.51,2.11,2.71,2.53,2.34,2.37,2.4,2.07,1.74,1.6,1.46,1.4,1.37,1.35,1.35,1.34,1.36,1.35,1.35,1.32,1.15,0.98,0.69,0.41,0.3,0.27,0.3,0.3,0.28,0.24,0.23,0.3,0.38,0.32,0.27,0.36,0.44,1.32,1.95,1.2,0.44,0.41,0.36,0.35,0.36,1.52,2.69,1.58,0.47,0.49,0.55,0.57,0.59,0.6,0.61,0.62,0.64,0.55,1.11,1.68,1.68,1.77,1.77,1.52,1.28,0.91,0.54,1.7,2.86,2.96,4.13,5.3,5.44,5.72,6.0,6.19,6.38,5.71,5.03,3.96,2.9,2.43,1.96,2.09,2.22,2.65,3.08,2.85,2.61,2.67,2.67,2.62,2.35,2.09,1.77,1.46,1.24,1.28,1.32:2
0.38,0.34,0.33,0.33,0.32,0.32,0.34,0.29,0.25,0.28,0.3,0.28,0.25,0.29,0.33,0.32,0.3,0.27,0.24,0.27,0.31,0.24,0.28,0.33,0.28,0.24,0.24,0.33,0.36,0.31,0.31,0.32,0.33,0.33,0.29,0.26,0.3,0.29,0.28,0.82,1.35,1.38,1.42,0.89,0.37,0.33,0.31,0.29,0.27,0.26,0.55,0.84,0.84,0.78,0.78,0.86,0.94,1.15,1.35,1.36,1.37,1.37,2.13,2.89,2.31,1.73,1.47,1.84,2.22,3.44,3.85,4.25,4.28,4.36,4.44,3.79,3.14,2.41,1.67,1.51,1.34,1.44,1.54,1.62,1.56,1.5,1.52,1.54,1.5,1.46,1.52,1.58,1.47,1.51,1.55,1.74,1.92,1.97,2.03,2.44,2.86,2.57,2.29,3.06,3.82,3.35,2.87,2.87,3.3,3.3,3.3,3.27,3.27,3.27,3.26,3.26,3.23,3.2,2.88,2.56,2.6,2.13,1.66,1.65,1.63,1.61,1.6,1.58,1.6,1.61,1.59,1.57,1.59,1.6,1.61,1.62,1.63,1.65,1.65,1.57,1.57,1.6,1.62,1.67:2
0.74,0.5,0.31,0.25,0.27,0.32,0.32,0.27,0.27,0.34,0.36,0.32,0.28,0.29,0.31,0.3,0.29,0.3,0.3,0.29,0.3,0.34,0.34,0.32,0.3,0.32,0.32,0.28,0.26,0.31,0.31,0.29,0.25,0.25,0.32,0.39,0.29,0.29,0.38,0.91,1.44,1.44,2.91,2.91,2.67,2.43,2.86,2.62,2.37,1.86,1.35,1.33,1.33,1.33,1.34,1.03,0.72,0.54,0.35,0.35,0.3,0.29,0.32,0.32,0.27,0.26,0.31,0.32,0.28,0.24,0.5,0.76,0.76,0.77,0.55,0.41,0.32,0.3,0.29,0.3,0.33,0.56,0.79,0.86,0.86,0.83,0.77,0.71,0.48,0.25,0.29,0.3,0.67,1.03,1.26,1.49,1.51,1.52,1.52,1.55,1.55,1.6,1.65,1.9,1.87,1.83,1.87,1.9,2.46,3.02,3.18,3.35,3.57,3.8,3.8,3.06,3.06,2.81,2.81,1.81,1.81,1.69,2.1,2.8,3.57,3.97,4.37,2.74,1.12,0.99,0.92,0.92,0.96,1.56,2.16,2.04,1.92,1.32,0.73,0.69,0.64,0.58,0.53,0.53:2
0.34,0.29,0.24,0.28,0.33,0.82,1.31,0.88,0.44,0.33,0.22,0.29,0.32,0.34,0.34,0.33,0.33,0.32,0.29,0.25,0.27,0.3,0.28,0.32,0.35,0.35,0.35,0.35,0.33,0.32,0.31,0.3,0.3,0.3,0.25,0.25,0.25,0.32,0.23,0.23,2.05,3.88,2.85,1.82,2.1,2.39,2.62,2.86,3.11,3.04,2.97,2.87,2.76,2.3,1.84,2.11,2.38,1.9,1.42,1.43,1.45,1.46,1.48,1.42,1.36,1.34,2.42,3.5,4.23,4.95,4.05,3.16,2.37,1.58,1.49,1.4,1.35,1.29,0.87,0.44,0.38,0.53,0.68,0.59,0.5,1.03,1.56,2.01,2.46,2.14,1.88,1.62,1.37,1.12,0.87,0.62,0.64,0.66,0.67,0.56,0.44,0.48,0.84,1.19,1.63,1.63,2.92,2.92,3.16,3.4,3.38,3.36,3.3,3.24,3.43,3.62,3.49,3.37,2.86,2.35,2.98,3.62,3.42,3.22,2.94,2.65,2.74,2.09,1.45,1.33,1.2,1.13,1.1,1.07,0.97,0.82,0.66,0.55,0.44,0.4,0.37,0.37,0.36,0.36:2
1.47,1.38,1.33,1.36,1.42,1.43,1.36,1.34,1.39,1.24,1.09,0.7,0.31,0.28,0.28,0.32,0.32,0.3,0.28,0.29,0.27,0.24,0.24,0.24,0.25,0.25,0.3,0.3,0.3,0.26,0.26,0.28,0.27,0.26,0.27,0.26,0.27,0.32,0.32,0.3,1.52,2.74,2.61,2.47,2.22,1.97,2.63,2.63,1.77,1.77,1.52,1.27,1.3,1.31,1.32,1.3,1.34,1.36,1.34,1.37,1.4,1.39,1.32,0.82,0.32,0.26,0.26,0.3,0.3,0.26,0.26,0.34,0.3,0.27,0.26,0.28,0.29,0.28,0.28,0.32,0.45,0.58,0.56,0.54,0.43,0.39,0.43,0.36,0.3,0.3,0.32,0.33,0.33,0.63,0.93,1.15,1.36,1.62,1.87,1.63,1.39,1.42,1.45,1.63,1.8,2.26,2.72,3.03,3.34,3.2,3.06,2.8,3.07,3.33,3.17,2.88,2.59,2.99,3.39,2.9,2.4,2.48,2.82,3.15,3.06,2.96,2.96,2.96,2.81,2.81,2.38,1.93,1.47,1.42,1.36,1.34,1.4,1.46,0.98,0.5,0.44,0.36,0.29,0.23:2
0.25,0.27,0.27,0.29,0.34,0.33,0.26,0.24,0.28,0.29,0.24,0.23,0.29,0.29,1.37,1.37,1.37,0.28,0.28,0.27,0.26,0.25,0.25,0.29,0.28,0.26,0.3,0.34,0.31,0.24,0.24,0.28,0.28,0.25,0.25,0.26,0.27,0.29,0.34,0.37,1.23,2.1,2.37,2.63,2.29,1.95,2.07,2.51,2.95,2.92,2.88,2.95,2.95,3.52,3.52,3.14,3.2,3.26,3.09,2.92,2.92,4.78,4.78,4.18,3.57,3.25,2.62,1.99,1.98,2.34,2.7,2.29,1.88,1.81,1.82,1.82,1.58,1.42,1.4,1.5,1.45,1.39,1.37,1.41,1.42,1.39,1.39,1.42,1.43,1.43,4.56,4.56,4.09,3.61,3.26,2.64,2.02,2.1,2.11,1.8,1.49,1.45,1.45,4.07,4.07,3.37,2.66,2.04,1.43,1.68,1.82,1.73,1.76,1.8,2.17,2.5,2.82,2.82,2.79,2.79,2.72,2.78,3.11,3.22,3.33,3.03,2.74,2.74,3.94,3.94,4.21,4.49,3.99,3.5,2.75,2.17,1.59,1.6,1.75,1.91,1.89,1.87,1.61,1.35:2
3.71,3.72,3.73,3.71,3.69,3.66,3.64,3.6,3.56,3.47,3.41,3.34,3.49,3.49,3.5,3.46,3.43,3.29,2.89,2.48,2.4,2.31,2.29,2.33,2.38,2.29,2.33,2.37,2.26,2.14,2.29,2.36,2.43,2.36,2.26,2.12,2.06,2.0,2.05,2.1,2.11,2.09,2.08,2.12,2.04,1.95,2.01,2.06,2.1,2.1,2.4,2.4,2.1,1.8,1.81,1.32,0.82,0.63,1.05,1.47,1.55,1.56,1.56,1.55,1.55,1.56,1.57,1.57,1.58,1.55,1.53,1.55,1.53,1.5,1.6,1.7,1.67,1.64,1.62,1.62,2.07,2.51,1.61,0.71,2.65,4.58,5.51,4.11,2.72,2.32,1.92,1.85,1.77,2.29,2.81,2.97,3.13,2.58,2.03,2.03,2.16,2.16,2.2,2.25,2.37,2.49,2.6,2.94,3.27,3.56,3.88,3.88,7.16,7.16,7.02,6.88,6.48,6.08,5.07,4.67,4.28,4.08,3.88,3.31,3.17,3.04,3.18,3.32,3.66,4.0,3.98,4.24,4.5,4.29,3.62,2.95,2.38,2.56,2.73,2.56,2.39,2.54,2.7,2.84:2
2.19,1.91,1.63,0.99,0.34,0.29,0.29,0.3,0.3,0.27,0.25,0.27,0.28,0.28,0.27,0.27,0.3,0.3,0.26,0.22,0.23,0.24,0.26,0.28,0.28,0.38,0.38,0.31,0.23,0.23,0.23,0.27,0.31,0.31,0.28,0.28,0.3,0.31,0.57,0.83,1.6,2.13,2.65,2.67,2.69,2.73,2.76,2.78,2.86,2.95,2.33,1.7,2.11,1.92,1.73,1.51,1.28,1.37,1.4,1.43,1.43,1.36,1.36,1.35,1.33,1.29,1.29,1.4,1.4,1.48,1.57,1.89,1.88,1.88,1.86,1.85,1.72,1.58,1.47,1.36,1.49,1.62,2.3,2.99,3.01,2.23,1.44,1.47,1.49,1.6,1.96,2.33,2.33,0.33,0.33,0.26,0.28,0.3,0.29,0.28,0.28,1.63,1.63,1.86,2.09,2.06,2.02,2.02,2.73,2.73,2.47,2.21,2.14,2.01,1.87,2.24,2.61,3.02,3.42,3.3,3.18,2.93,2.69,2.64,2.08,1.53,1.48,1.48,4.78,4.78,4.35,4.03,3.7,2.99,2.29,1.54,0.94,0.35,0.25,0.58,0.9,0.8,0.71,0.69:2
0.25,0.29,0.27,0.25,0.26,0.25,0.24,0.24,0.27,0.3,0.28,0.26,0.29,0.28,0.28,0.28,0.27,0.25,0.28,0.32,0.33,0.32,0.31,0.31,0.29,0.29,0.28,0.26,0.26,0.26,0.25,0.26,0.26,0.26,0.28,0.29,0.29,0.28,0.27,0.25,1.19,2.12,1.94,2.06,2.18,2.54,2.75,2.96,2.15,1.89,1.64,1.63,1.62,1.61,1.61,1.61,1.6,1.6,1.61,1.6,1.58,1.58,1.58,1.58,0.48,0.48,0.52,0.56,0.56,0.54,0.53,0.53,0.53,0.53,0.51,0.49,0.5,0.51,0.51,0.51,0.56,0.56,0.56,0.56,2.07,2.07,1.29,0.52,0.52,0.52,0.51,0.48,1.17,1.87,1.41,0.95,1.2,1.45,1.4,1.35,1.28,1.22,1.02,0.81,0.84,0.88,0.92,1.19,1.45,1.89,2.34,2.73,3.13,3.17,3.34,3.5,3.19,2.87,2.77,2.68,2.32,1.96,1.76,1.57,1.7,1.84,1.92,2.01,2.25,2.2,2.14,1.88,1.61,1.44,1.26,0.85,0.43,0.34,0.24,0.28,0.28,0.27,0.25,0.23:2
0.23,0.17,0.13,0.12,0.14,0.16,0.13,0.15,0.19,0.18,0.16,0.16,0.18,0.16,0.16,0.17,0.16,0.16,0.17,0.19,0.16,0.14,0.15,0.15,0.14,0.14,0.17,0.19,0.17,0.16,0.17,0.18,0.16,0.17,0.17,0.16,0.16,0.19,0.19,0.15,0.14,0.18,0.27,0.37,0.81,1.24,1.25,1.21,0.89,0.57,0.37,0.16,0.17,0.17,0.14,0.16,0.19,0.19,0.13,0.14,0.2,0.17,0.13,0.14,0.17,0.18,0.16,0.16,0.16,0.16,0.16,0.19,0.17,0.13,0.11,0.15,0.19,0.13,0.14,0.19,0.23,0.23,0.24,0.45,0.66,0.61,0.49,0.38,0.43,0.8,1.18,1.61,2.04,2.34,2.64,3.23,3.82,3.82,2.17,2.17,4.13,6.08,3.99,1.91,1.34,2.16,2.97,3.75,3.28,2.81,3.47,4.13,3.21,2.29,2.29,2.89,2.89,2.99,3.1,2.05,1.9,1.74,3.3,3.25,3.2,3.02,2.33,1.64,2.17,2.7,2.7,1.57,1.57,1.57,0.23,0.23,0.22,0.23,0.23,0.19,0.16,0.18,0.23,0.28:2
0.7,0.67,0.64,0.41,0.19,0.18,0.17,0.18,0.2,0.21,0.23,0.23,0.28,0.19,0.16,0.23,0.23,0.59,0.95,1.3,1.12,0.94,0.58,0.22,0.22,0.2,0.2,0.28,0.23,0.18,0.19,0.19,0.15,0.11,0.14,0.17,0.15,0.12,0.14,0.16,0.16,0.15,0.19,0.22,0.22,0.22,0.21,0.2,0.23,0.25,0.21,0.17,0.19,0.21,0.24,0.28,0.45,0.34,0.23,0.26,0.28,0.29,0.81,1.33,1.81,2.3,1.84,1.38,1.46,1.8,2.15,2.15,0.97,0.97,0.68,0.39,0.52,0.65,0.63,0.61,0.5,0.4,0.48,0.56,0.79,1.2,1.62,1.64,1.62,1.6,1.6,1.68,1.58,1.58,1.61,1.53,1.46,1.28,0.88,0.48,0.46,0.48,0.51,0.64,1.06,1.47,1.75,2.03,1.51,0.99,0.99,3.67,3.67,2.75,1.84,2.27,2.69,2.33,1.97,1.48,0.98,2.24,3.54,4.83,5.18,4.73,4.29,4.29,2.35,2.35,2.3,2.25,2.2,2.16,2.05,1.94,1.93,1.95,1.98,1.84,1.66,1.48,1.35,1.23:2
0.21,0.25,0.24,0.24,0.24,0.25,0.24,0.22,0.24,0.26,0.23,0.21,0.23,0.26,0.27,0.24,0.21,0.24,0.27,0.24,0.21,0.24,0.26,0.24,0.21,0.23,0.26,0.49,0.72,1.0,1.29,0.8,0.56,0.31,0.23,0.22,0.22,0.22,0.22,0.22,0.22,0.22,0.22,0.18,0.33,0.49,0.49,0.49,0.88,1.26,0.92,0.58,0.51,0.45,0.51,0.57,0.59,1.01,1.42,2.12,2.81,2.01,1.2,0.97,0.74,0.74,1.65,1.65,1.15,0.64,0.62,0.59,0.58,0.56,0.58,0.6,0.63,0.66,0.47,0.27,0.39,0.37,0.34,0.35,0.35,0.36,0.37,0.35,0.36,0.37,0.31,0.24,0.71,1.18,1.38,1.58,1.56,1.54,1.6,1.52,1.43,1.45,1.46,1.56,1.66,1.37,1.08,0.84,0.61,0.48,0.51,0.53,0.53,4.34,4.34,3.42,2.54,1.66,1.97,2.28,3.46,4.64,3.71,2.78,2.78,3.58,3.58,2.95,2.31,2.41,2.24,2.08,1.84,1.81,1.78,1.65,1.53,1.53,0.15,0.15,0.16,0.17,0.16,0.15:2
0.97,0.7,0.62,0.53,0.42,0.3,0.29,0.27,0.26,0.24,0.25,0.26,0.26,0.27,0.27,0.28,0.36,0.37,0.33,0.31,0.3,0.3,0.28,0.25,0.28,0.31,0.67,1.02,1.36,1.02,0.67,0.49,0.31,0.29,0.26,0.26,0.26,0.84,1.43,2.16,2.89,2.75,2.61,2.27,2.07,1.87,1.69,1.51,1.41,1.31,1.41,1.36,1.32,1.32,1.43,1.43,1.17,0.91,1.22,1.53,1.4,2.39,3.38,2.41,1.45,1.38,1.39,1.41,1.4,1.51,1.61,1.2,0.78,0.58,0.37,0.42,0.43,0.43,0.4,0.4,0.4,0.41,0.41,0.4,0.44,0.48,0.45,0.47,0.5,1.57,2.64,2.4,2.59,2.78,2.81,2.85,2.79,1.59,0.39,0.39,0.41,0.41,0.41,0.4,0.47,0.48,0.49,1.7,2.92,2.41,1.9,1.8,2.12,2.43,3.02,3.62,4.06,3.69,3.33,3.08,3.13,3.18,3.47,3.76,3.45,3.14,2.89,2.65,2.51,2.38,2.37,2.1,1.84,1.43,1.01,0.92,0.84,0.74,0.78,0.83,0.83,0.76,0.7,0.75:2
2.85,2.04,1.23,0.95,0.66,0.76,0.85,0.86,0.55,0.24,0.3,0.26,0.22,0.23,0.27,0.25,0.23,0.25,0.27,0.23,0.17,0.18,0.18,0.18,0.19,0.18,0.17,0.18,0.19,0.2,0.23,0.25,0.26,0.2,0.17,0.17,0.18,0.18,0.17,0.17,0.17,0.18,0.19,0.21,0.24,0.26,0.27,0.24,0.19,0.11,0.57,1.03,1.27,1.99,2.7,1.5,0.3,0.5,0.77,1.03,0.95,0.86,0.51,0.16,0.25,0.35,0.37,0.39,0.38,0.36,0.55,0.74,0.66,0.58,0.61,1.21,1.82,2.02,2.22,2.03,1.85,1.9,1.68,1.45,1.5,1.54,1.73,1.91,2.1,1.83,1.56,2.13,2.7,2.87,3.05,2.47,2.05,1.62,1.8,1.98,1.8,1.72,1.64,1.78,1.92,1.87,1.82,2.14,2.46,3.1,3.74,3.1,2.45,2.18,1.56,0.94,0.92,0.95,0.99,1.23,1.46,1.18,0.89,0.86,0.84,1.59,2.34,2.41,2.48,2.04,1.59,2.31,3.03,1.87,0.71,0.75,0.79,0.77,0.78,0.78,1.6,2.42,2.11,1.79:2
0.31,0.31,0.3,0.3,0.3,0.3,0.32,0.33,0.32,0.3,0.29,0.27,0.29,0.3,0.3,0.3,0.31,0.28,0.26,0.28,0.32,0.27,0.23,0.24,0.28,0.33,0.32,0.31,0.32,0.29,0.26,0.24,0.23,0.26,0.28,0.23,0.33,0.43,0.36,0.85,1.34,1.4,1.03,0.65,0.46,0.27,0.35,0.31,0.27,0.25,0.28,0.3,0.25,0.28,0.32,0.56,0.79,0.83,0.88,0.81,0.75,0.71,0.67,0.53,0.39,0.44,0.49,0.47,0.45,0.41,0.44,0.47,0.4,0.99,1.59,3.01,4.43,3.53,2.62,2.04,1.45,1.41,1.37,1.39,1.4,1.33,1.39,1.46,1.42,1.36,1.38,1.4,1.38,1.03,0.68,0.49,0.3,0.31,0.32,0.31,0.31,0.3,0.28,0.29,0.31,0.3,0.29,0.34,0.38,0.66,0.95,0.95,2.9,2.9,2.56,2.23,2.91,3.59,2.74,2.57,2.39,3.1,3.8,3.8,3.61,3.61,2.49,2.11,1.73,1.52,1.38,1.24,1.38,1.52,0.93,0.34,0.36,0.38,0.32,0.26,0.29,0.31,0.27,0.24:2
3.06,2.88,3.29,3.7,3.7,1.66,1.66,1.66,1.63,1.63,1.63,0.65,0.65,0.5,0.97,1.45,0.93,0.41,0.45,0.5,0.44,0.37,0.4,0.43,0.94,1.44,1.6,1.33,1.06,0.77,0.47,0.47,0.35,0.43,0.43,0.4,0.37,0.42,0.48,0.43,0.39,0.37,0.36,0.4,0.43,0.35,0.45,0.54,0.45,0.35,0.36,0.44,0.53,0.6,0.67,0.69,1.03,1.36,1.08,0.8,1.08,1.36,1.5,1.64,1.74,1.84,1.9,1.97,1.92,1.55,1.18,0.84,1.09,1.34,1.63,1.92,1.82,1.5,1.18,0.92,0.64,0.35,0.36,0.36,0.31,0.32,0.34,0.34,0.33,0.33,0.32,0.9,1.47,1.46,1.46,1.24,1.02,0.91,0.77,0.64,0.8,0.97,0.99,1.17,1.36,1.72,2.09,1.63,1.16,1.13,1.38,1.62,2.89,3.88,4.86,4.82,4.78,3.51,2.24,3.67,5.1,4.42,3.75,3.01,2.28,2.4,2.51,2.35,2.18,1.77,1.35,1.29,1.18,1.06,0.78,0.49,0.42,0.35,0.38,0.41,0.41,0.34,0.35,0.35:2
0.33,0.34,0.36,0.31,0.27,0.28,0.29,0.27,0.24,0.27,0.31,0.31,0.33,0.35,0.35,0.26,0.3,0.3,0.26,0.22,0.27,0.32,0.28,0.25,0.24,0.23,0.27,0.3,0.27,0.25,0.3,0.36,0.29,0.23,0.3,0.44,0.58,0.97,1.35,1.17,0.98,0.65,0.32,0.31,0.29,0.29,2.26,2.26,2.3,2.34,2.41,2.48,2.62,2.84,3.05,2.71,2.36,2.32,2.27,2.5,2.73,2.15,1.57,1.54,1.5,1.54,1.57,1.6,1.64,1.64,1.57,1.55,1.55,1.79,2.03,2.02,2.02,1.96,1.91,1.77,1.64,1.55,1.47,1.42,1.38,1.21,1.04,0.96,0.89,0.98,0.93,0.87,0.9,0.85,0.8,0.82,0.84,0.86,0.87,0.98,1.1,1.13,1.16,1.16,3.45,3.45,3.45,5.29,5.29,4.46,3.93,3.41,3.55,3.69,4.09,4.26,4.43,4.12,3.89,3.67,3.67,3.55,3.55,3.5,3.46,3.41,3.47,3.53,3.49,3.44,3.32,3.19,3.14,3.08,3.09,3.1,3.09,3.09,2.92,2.75,2.99,3.23,4.02,4.81:2
1.31,1.05,0.8,0.75,0.71,0.7,0.69,0.71,0.72,0.74,0.75,0.7,0.66,0.68,0.7,0.64,0.69,0.74,0.7,0.65,0.68,0.7,0.7,0.7,0.7,0.75,0.75,0.72,0.69,0.64,0.67,0.69,0.74,1.09,1.43,0.96,0.49,0.41,0.34,0.34,0.34,0.23,0.23,0.26,0.29,0.23,0.95,1.66,2.23,2.81,2.93,3.05,2.51,1.97,1.69,1.41,1.49,1.57,1.57,1.52,1.47,1.45,1.43,1.5,1.56,1.63,1.7,1.43,1.45,1.46,1.54,1.62,1.48,1.35,0.94,0.54,0.54,0.55,0.55,0.68,0.81,0.81,0.83,0.85,1.15,1.44,1.45,1.46,1.62,1.79,2.33,2.88,2.72,2.13,1.55,0.93,0.31,0.37,0.43,0.97,1.5,1.05,0.6,2.74,4.88,4.03,3.18,3.09,3.0,3.07,3.14,3.15,3.15,3.25,4.55,5.85,6.56,7.27,6.48,5.69,4.6,3.52,3.49,3.19,2.89,2.89,2.95,2.95,2.32,2.0,1.68,1.8,1.75,1.71,1.7,1.69,1.64,1.6,1.64,1.69,1.74,1.79,1.6,1.41:2
1.36,1.36,1.36,1.39,1.43,1.1,0.76,0.56,0.36,0.29,0.21,0.31,0.27,0.24,0.26,0.3,0.34,0.34,0.25,0.27,0.27,0.29,0.29,0.28,0.28,0.3,0.31,0.26,0.22,0.22,0.3,0.22,0.34,0.34,0.34,0.3,0.27,0.33,0.33,0.84,1.35,1.24,1.12,1.65,2.19,2.47,2.75,3.02,2.82,2.62,2.17,1.73,1.48,1.44,1.41,1.34,1.27,1.3,1.34,1.32,1.3,1.31,1.32,1.32,1.32,1.35,1.34,1.34,1.31,1.28,0.92,0.57,0.42,0.26,0.28,0.29,0.29,0.29,0.27,0.28,0.29,0.28,0.26,0.36,0.45,0.48,0.52,0.5,0.48,0.5,0.53,0.47,0.42,0.47,0.52,0.52,0.52,0.53,0.42,0.3,0.29,0.28,0.26,0.25,0.24,0.23,0.27,0.31,1.21,2.11,1.27,0.44,0.45,0.84,1.24,2.36,3.08,3.8,3.64,3.48,2.6,1.72,1.6,1.81,2.02,2.43,2.84,3.36,2.45,1.55,3.07,1.89,0.72,0.57,0.42,0.99,1.56,1.56,1.35,1.35,0.88,0.4,0.32,0.23:2
0.42,0.48,0.45,0.42,0.51,0.6,0.88,1.16,1.32,1.49,1.35,1.21,0.81,0.4,0.45,0.51,0.51,0.46,0.46,0.46,0.45,0.44,0.44,0.44,0.46,0.46,0.48,0.45,0.42,0.42,0.42,0.45,0.45,0.45,0.47,0.47,0.5,0.52,1.1,1.68,2.14,2.6,2.48,2.21,1.93,2.12,2.3,2.45,2.6,2.24,2.19,2.14,2.23,2.14,2.06,1.99,1.91,1.98,2.05,2.03,2.01,1.82,1.64,1.64,1.57,1.57,1.56,1.56,1.56,1.61,1.61,1.56,1.5,1.45,1.39,1.39,4.85,4.85,4.19,3.52,5.22,6.93,6.32,5.01,3.7,2.79,2.79,3.68,3.68,3.34,3.2,3.06,3.09,2.68,2.27,1.87,1.47,1.41,1.42,1.44,1.5,1.26,1.01,0.68,0.35,0.52,0.7,0.85,1.0,1.7,2.4,3.05,3.71,2.89,2.08,1.8,1.53,1.84,2.19,2.54,2.65,2.76,2.31,1.85,1.68,1.49,1.3,1.09,0.87,0.91,0.92,0.93,0.93,0.77,0.77,0.69,0.61,0.62,0.62,0.38,0.32,0.26,0.26,0.26:2
1.41,1.14,0.87,0.59,0.32,0.34,0.32,0.3,0.31,0.31,0.29,0.3,0.31,0.3,0.29,0.3,0.31,0.29,0.28,0.27,0.33,0.33,0.35,0.35,0.32,0.29,0.28,0.26,0.28,0.3,0.27,0.23,0.26,0.3,0.27,0.24,0.33,0.43,0.78,1.14,3.14,2.56,1.97,2.07,2.16,2.35,2.54,2.32,2.11,1.73,1.36,1.39,1.41,1.43,1.39,1.34,1.37,1.41,1.62,1.83,1.83,1.79,1.79,1.72,1.54,1.37,1.36,1.36,1.43,1.43,1.21,0.99,0.69,0.39,0.47,0.68,0.88,1.05,1.27,1.49,1.45,1.41,1.41,1.39,1.39,1.4,0.84,0.28,0.29,0.28,0.28,0.32,0.37,0.34,0.31,0.32,0.33,0.36,0.4,0.35,0.31,0.31,0.32,0.43,0.54,0.58,0.61,1.13,1.64,1.85,2.07,2.37,2.66,2.65,2.64,2.28,1.92,2.07,1.91,1.75,1.58,1.5,1.42,1.17,0.92,0.75,0.58,0.59,0.58,0.56,0.56,0.55,0.55,0.94,1.33,2.66,3.99,3.43,2.87,3.19,3.51,3.53,3.56,3.67:2
0.32,0.45,0.44,0.43,0.41,0.38,0.36,0.33,0.31,0.28,0.73,1.18,1.33,1.48,1.48,0.32,0.32,0.34,0.35,0.35,0.25,0.33,0.33,0.37,0.4,0.33,0.25,0.26,0.29,0.32,0.28,0.24,0.28,0.35,0.42,0.32,0.32,0.32,0.3,0.29,0.28,0.28,0.3,0.36,0.42,0.38,0.61,0.85,0.62,0.4,0.37,0.34,0.27,0.52,0.77,1.46,1.49,1.52,1.43,1.34,1.33,1.32,1.25,1.29,1.33,1.33,1.33,1.31,1.31,1.31,1.3,1.3,1.3,1.3,1.37,1.37,1.36,1.36,1.37,1.39,1.42,1.39,1.96,2.54,1.78,1.03,1.09,1.14,0.9,0.66,0.59,0.52,1.55,2.57,1.53,0.5,1.12,1.74,1.13,0.52,0.56,0.59,0.74,0.88,1.09,1.29,1.4,2.27,3.15,3.08,2.92,2.76,2.65,2.55,2.67,2.8,2.7,2.77,2.84,2.26,2.11,1.95,2.06,2.16,2.58,3.01,2.91,2.49,2.06,2.64,3.21,2.31,1.41,1.3,1.2,0.79,0.38,1.49,2.59,1.41,0.24,0.29,0.34,0.4:2
2.37,2.37,2.37,1.9,1.43,1.43,1.44,1.44,1.42,2.24,3.06,2.5,1.95,1.8,1.66,1.69,1.67,1.62,1.56,1.53,1.5,1.09,0.67,0.5,0.33,0.28,0.27,0.31,0.31,0.27,0.26,0.28,0.32,0.33,0.33,0.34,0.38,0.35,0.28,0.26,0.3,0.31,0.27,0.24,0.24,0.98,1.72,2.63,2.82,3.01,2.48,2.12,1.77,1.69,1.62,1.65,1.67,1.68,1.7,1.74,1.78,1.87,1.94,1.96,1.91,1.89,1.91,1.93,1.9,1.82,1.71,1.61,1.51,1.51,1.52,1.33,1.15,1.27,1.4,1.39,1.38,1.39,1.4,1.4,1.4,1.47,1.54,1.54,1.51,1.5,1.49,1.5,1.51,1.49,1.43,1.43,0.33,0.33,0.27,0.3,0.37,0.45,2.27,4.1,4.21,4.32,3.54,2.77,2.65,2.91,3.18,3.21,3.89,4.58,4.23,3.88,3.58,3.29,2.73,2.18,2.11,2.04,2.09,2.14,2.17,2.56,2.95,3.16,3.43,3.7,5.05,6.41,6.32,6.15,5.97,4.15,2.33,2.12,1.97,1.91,2.35,2.79,2.79,2.79:2
3.75,4.05,4.35,4.06,3.62,3.18,2.88,2.59,2.54,2.5,2.47,2.43,2.47,2.51,2.46,2.48,2.5,2.48,2.46,2.45,2.45,2.49,2.2,1.91,1.69,1.48,1.43,1.39,1.39,1.4,1.39,1.37,1.38,1.4,1.38,1.36,1.31,1.39,1.46,1.43,1.44,1.44,1.33,1.22,1.3,1.39,1.36,1.33,1.22,1.11,0.99,1.73,2.47,1.99,1.52,1.38,1.56,1.73,2.07,2.41,2.41,3.2,3.2,3.59,3.92,4.25,3.3,2.46,1.61,1.54,1.47,1.44,1.4,1.44,1.43,1.41,2.26,3.1,3.13,3.16,2.58,1.99,1.76,1.53,1.53,1.8,1.8,2.2,2.61,2.06,1.51,1.53,1.55,1.57,1.54,2.27,3.01,2.69,2.38,2.34,2.31,2.03,1.74,1.5,1.25,1.35,1.45,1.92,2.39,2.58,2.77,3.42,4.07,4.18,4.18,5.69,5.69,5.69,5.05,5.05,3.99,2.93,2.35,1.77,1.79,2.01,2.23,2.62,3.02,4.05,3.26,2.48,2.42,2.37,2.28,2.25,2.25,2.23,2.22,1.39,0.55,0.56,0.56,0.44:2
0.25,0.26,0.29,0.32,0.28,0.24,0.29,0.33,0.32,0.33,0.74,1.15,1.25,1.35,0.87,0.38,0.33,0.33,0.31,0.31,0.29,0.28,0.27,0.26,0.34,0.41,0.41,0.3,0.3,0.29,0.28,0.25,0.25,0.35,0.34,0.25,0.25,0.3,0.29,0.29,0.32,0.35,0.72,1.1,1.06,1.02,1.11,1.21,1.09,1.24,1.39,1.47,1.49,1.5,1.57,1.64,1.4,1.16,0.95,1.29,1.62,1.92,2.23,2.44,2.64,2.25,1.85,1.66,1.48,1.35,1.23,1.01,0.8,0.81,0.82,1.36,1.9,1.78,1.66,1.86,1.8,1.75,1.73,1.72,1.76,1.8,1.8,2.02,2.27,2.27,2.66,3.05,3.2,3.11,3.02,2.73,2.44,1.88,1.32,1.65,1.98,1.96,1.95,2.24,2.53,2.56,2.54,2.53,2.37,2.21,2.75,3.27,3.8,4.47,5.15,5.01,5.01,5.45,5.45,5.06,4.68,4.68,3.32,3.32,2.71,2.39,2.06,2.03,1.99,2.53,3.07,3.07,4.84,4.84,3.87,2.77,1.67,1.67,1.67,1.67,2.24,2.24,1.46,0.68:2
0.15,0.23,0.19,0.16,0.14,0.18,0.23,0.23,0.73,1.24,0.93,0.63,0.39,0.14,0.21,0.27,0.22,0.18,0.17,0.18,0.19,0.19,0.17,0.15,0.14,0.13,0.14,0.14,0.14,0.19,0.16,0.13,0.11,0.15,0.19,0.19,0.2,0.18,0.18,0.18,0.17,0.17,0.18,0.72,1.27,0.79,0.31,0.63,0.95,1.14,1.32,1.24,1.75,2.27,1.8,1.34,1.31,1.31,1.34,2.36,3.39,2.34,1.3,0.73,0.16,0.17,0.18,0.19,0.21,0.2,0.2,0.16,0.13,0.11,0.15,0.19,0.19,0.2,0.19,0.18,0.18,0.17,0.2,0.23,0.22,0.18,0.15,0.16,0.17,0.13,0.13,0.19,0.19,0.16,0.14,0.11,0.15,0.2,0.19,0.19,0.18,0.18,0.18,0.18,0.19,0.2,0.25,0.2,0.16,1.57,2.98,3.7,3.73,3.76,3.9,3.78,3.66,3.2,2.73,2.33,1.92,2.05,2.18,2.24,2.1,1.96,1.71,1.46,1.4,1.36,1.39,1.42,1.36,1.35,1.33,2.38,2.61,2.83,2.23,1.64,1.16,0.67,0.48,0.29:2
0.39,0.39,0.39,0.33,0.28,0.3,0.32,0.33,0.32,0.32,0.31,0.31,0.31,0.29,0.28,0.26,0.25,0.25,0.24,0.24,0.25,0.25,0.23,0.22,0.25,0.25,0.25,0.24,0.23,0.24,0.25,0.22,0.19,0.22,0.26,0.22,0.23,0.24,0.24,0.24,0.16,0.92,1.68,1.01,0.34,1.01,1.69,1.56,1.42,1.36,1.3,1.3,1.31,1.31,1.32,1.33,1.33,1.31,1.29,0.94,0.59,0.42,0.25,0.25,0.2,0.2,0.2,0.2,0.21,0.22,0.16,0.19,0.22,0.22,0.22,0.18,0.13,0.19,0.25,0.19,0.17,0.14,0.26,0.38,0.26,0.23,0.19,0.26,0.29,0.32,0.27,0.33,0.38,0.34,0.3,0.26,0.21,0.27,0.28,0.28,0.24,0.2,0.25,0.27,0.29,0.24,0.2,0.24,0.27,0.3,0.2,0.47,0.74,1.24,1.75,1.4,1.73,2.06,2.23,2.4,1.88,1.36,0.83,2.04,3.25,2.73,2.22,2.22,1.42,1.42,1.47,1.48,1.49,2.04,2.59,2.59,2.67,2.67,2.67,0.98,0.98,0.58,0.58,0.58:1
0.14,0.19,0.19,0.16,0.16,0.18,0.17,0.16,0.17,0.17,0.16,0.18,0.18,0.14,0.13,0.16,0.19,0.14,0.15,0.18,0.18,0.15,0.16,0.19,0.17,0.16,0.16,0.17,0.16,0.18,0.17,0.14,0.15,0.17,0.18,0.1,0.37,0.64,0.89,1.14,1.19,1.24,0.68,0.12,0.16,0.17,0.16,0.18,0.16,0.14,0.15,0.16,0.16,0.13,0.16,0.14,0.12,0.14,0.17,0.18,0.16,0.16,0.16,0.16,0.17,0.22,0.25,0.25,0.27,0.29,0.17,0.13,0.17,0.18,0.16,0.15,0.16,0.16,0.16,0.18,0.16,0.14,0.16,0.18,0.16,0.13,0.17,0.14,0.1,0.13,0.17,0.18,0.16,0.16,0.16,0.16,0.16,0.18,0.15,0.15,0.18,0.2,0.18,0.2,0.22,0.21,0.2,0.22,0.71,1.2,1.21,1.26,1.33,1.41,1.48,1.15,0.83,0.62,0.4,0.37,0.32,0.26,0.23,0.25,0.24,0.23,0.23,0.25,0.25,0.21,0.22,0.26,0.29,0.39,0.48,0.62,0.39,0.17,0.14,0.7,1.25,1.21,1.2,1.24:1
0.37,0.37,0.34,0.32,0.31,0.32,0.28,0.24,0.25,0.29,0.3,0.26,0.24,0.27,0.29,0.28,0.25,0.3,0.37,0.39,0.33,0.29,0.32,0.3,0.27,0.23,0.26,0.31,0.31,0.25,0.24,0.29,0.3,0.27,0.27,0.32,0.37,0.37,0.33,0.32,0.31,0.29,0.27,0.27,0.28,0.28,0.27,0.27,0.29,0.28,0.26,0.26,0.31,0.34,0.34,0.29,0.88,1.47,1.39,1.33,1.31,0.82,0.32,0.26,0.24,0.28,0.3,0.28,0.23,0.27,0.34,0.36,0.33,0.3,0.33,0.3,0.27,0.23,0.26,0.31,0.31,0.25,0.24,0.28,0.3,0.27,0.24,0.27,0.33,0.35,0.33,0.33,0.34,0.34,0.29,0.27,0.28,0.28,0.27,0.27,0.29,0.28,0.27,0.26,0.29,0.32,0.32,0.33,0.35,0.38,0.35,0.28,0.27,0.3,0.3,0.25,0.24,0.28,0.28,0.27,0.23,0.26,0.31,0.34,0.31,0.31,0.34,0.8,1.26,1.3,1.34,1.41,1.1,0.79,0.55,0.3,0.31,0.28,0.25,0.26,0.29,0.31,0.31,0.31:1
2.06,1.86,1.34,0.82,0.54,0.26,0.27,0.26,0.25,0.25,0.27,0.29,0.25,0.23,0.22,0.19,0.18,0.17,0.19,0.19,0.18,0.17,0.19,0.2,0.23,0.25,0.27,0.26,0.25,0.23,0.22,0.19,0.18,0.17,0.19,0.18,0.14,0.57,0.99,1.45,1.86,2.63,3.4,2.49,1.59,1.5,1.42,1.39,1.36,1.28,1.24,1.26,1.24,1.19,0.87,0.53,0.26,0.24,0.25,0.26,0.23,0.18,0.17,0.2,0.19,0.16,0.17,0.2,0.19,0.17,0.2,0.25,0.27,0.24,0.25,0.24,0.21,0.17,0.18,0.19,0.19,0.17,0.18,0.19,0.19,0.18,0.22,0.25,0.27,0.25,0.25,0.23,0.21,0.17,0.18,0.18,0.19,0.17,0.18,0.19,0.19,0.18,0.22,0.25,0.27,0.25,0.44,0.84,1.24,0.89,0.53,0.37,0.2,0.21,0.26,0.26,0.26,0.34,0.43,0.53,0.63,0.44,0.25,0.23,0.19,0.12,0.12,3.48,3.48,2.79,2.09,2.48,2.87,2.62,2.33,1.83,1.32,1.0,0.72,0.53,0.36,0.25,0.15,0.23:1
2.88,2.37,1.87,2.42,2.98,2.3,1.39,0.48,0.3,0.13,0.18,0.19,0.21,0.32,0.43,0.43,0.57,0.5,0.35,0.35,0.29,0.22,0.19,0.19,0.19,0.21,0.23,0.19,0.15,0.23,0.21,0.2,0.21,0.23,0.18,0.13,0.16,0.19,0.18,0.17,0.18,0.19,0.33,1.03,1.73,1.62,1.51,1.61,1.33,1.05,1.17,1.3,1.3,1.29,1.3,1.3,1.17,0.73,0.29,0.38,0.46,0.56,0.66,1.11,1.55,1.54,1.53,1.51,1.49,1.1,0.72,0.64,0.56,0.49,0.72,0.96,1.09,1.23,0.71,0.19,0.18,0.16,0.22,0.28,0.22,0.16,0.18,0.21,0.17,0.12,0.12,0.21,0.14,0.14,0.87,1.59,0.92,0.25,0.21,0.23,0.25,0.22,0.2,0.18,0.17,0.22,0.26,0.28,0.31,0.34,0.37,0.27,0.17,0.25,1.0,1.75,1.42,0.88,0.33,0.35,0.32,0.29,0.28,0.27,0.27,0.27,0.28,0.29,0.28,0.27,0.65,1.04,1.41,1.78,2.45,2.24,2.04,1.8,1.56,1.08,0.61,0.42,0.24,0.22:1
0.25,0.24,0.22,0.17,0.17,0.18,0.21,0.18,0.48,0.86,1.21,1.21,0.7,0.2,0.25,0.27,0.23,0.17,0.16,0.18,0.19,0.17,0.16,0.17,0.19,0.18,0.16,0.2,0.24,0.27,0.24,0.21,0.19,0.18,0.18,0.16,0.16,0.17,0.18,0.14,0.75,1.36,0.94,0.53,0.57,0.96,1.34,1.33,1.27,1.0,0.72,0.47,0.23,0.21,0.17,0.15,0.17,0.21,0.22,0.21,0.22,0.26,0.27,0.23,0.16,0.15,0.19,0.21,0.18,0.15,0.16,0.19,0.21,0.19,0.2,0.23,0.27,0.28,0.23,0.19,0.18,0.19,0.19,0.17,0.17,0.18,0.19,0.19,0.18,0.22,0.26,0.27,0.26,0.23,0.21,0.2,0.19,0.19,0.17,0.14,0.55,0.95,1.11,1.22,0.85,0.49,0.3,0.31,0.32,0.3,0.28,0.25,0.24,0.26,0.32,0.39,0.59,0.7,0.81,0.71,0.61,1.22,1.84,2.26,2.68,2.17,1.67,1.63,2.14,2.39,1.92,1.21,1.03,0.78,0.54,0.44,0.35,0.32,0.29,0.24,0.21,0.23,0.26,0.29:1
0.41,0.3,0.24,0.28,0.28,0.28,0.23,0.25,0.31,0.31,0.26,0.24,0.3,0.35,0.36,0.33,0.33,0.37,0.36,0.29,0.27,0.29,0.31,0.28,0.26,0.28,0.29,0.29,0.27,0.28,0.3,0.33,0.34,0.35,0.36,0.35,0.33,0.3,0.3,0.29,0.27,0.26,0.29,0.3,0.27,0.26,0.28,0.31,0.3,0.3,0.33,0.38,0.37,0.32,0.3,0.31,0.31,0.28,0.23,0.25,0.29,0.31,0.25,0.24,0.29,0.27,0.26,0.28,0.62,1.11,1.41,1.36,1.32,1.32,0.78,0.24,0.23,0.26,0.31,0.31,0.25,0.24,0.29,0.34,0.62,1.11,0.87,0.5,0.47,0.43,0.38,1.35,2.32,2.28,2.24,1.88,1.51,1.49,0.98,0.47,0.42,0.37,0.31,0.25,0.22,0.23,0.22,0.18,0.17,0.22,0.27,0.3,0.27,0.23,0.21,0.21,0.19,0.2,0.22,0.26,0.24,0.2,0.18,0.19,0.21,0.21,0.22,0.24,0.26,0.24,0.2,1.71,3.22,2.24,1.27,1.59,1.91,1.65,1.4,1.11,0.81,0.6,0.39,0.32:1
0.38,0.32,0.29,0.3,0.3,0.27,0.23,0.22,0.26,0.31,0.24,0.24,0.29,0.28,0.27,0.29,0.34,0.38,0.38,0.31,0.28,0.3,0.28,0.25,0.23,0.27,0.31,0.31,0.25,0.25,0.29,0.32,0.31,0.32,0.35,0.37,0.36,0.32,0.29,0.29,0.29,0.27,0.27,0.28,0.29,0.27,0.26,0.28,0.28,0.29,0.3,0.35,0.37,0.35,0.33,0.33,0.32,0.28,0.26,0.26,0.29,0.31,0.78,1.24,1.32,1.34,1.31,1.31,0.43,0.43,0.37,0.31,0.31,0.34,0.33,0.26,0.23,0.24,0.26,0.29,0.24,0.25,0.32,0.3,0.25,0.25,0.34,0.37,0.36,0.31,0.31,0.35,0.33,0.26,0.24,0.28,0.31,0.28,0.25,0.26,0.29,0.29,0.26,0.31,0.35,0.37,0.35,0.34,0.34,0.32,0.29,0.27,0.29,0.28,0.27,0.26,0.28,0.3,0.28,0.26,0.29,0.35,0.36,0.34,0.33,0.36,0.36,0.3,0.25,0.28,0.31,0.3,0.24,0.26,0.31,0.36,0.73,1.1,1.33,1.38,1.43,1.16,0.9,0.43:1
0.21,0.17,0.13,0.09,0.14,0.19,0.19,0.2,0.19,0.17,0.16,0.21,0.25,0.14,0.11,0.08,0.14,0.16,0.18,0.13,0.16,0.19,0.22,0.24,0.25,0.2,0.15,0.12,0.12,0.18,0.18,0.15,0.12,0.13,0.15,0.23,0.32,0.32,0.72,0.72,0.57,0.42,0.97,1.52,1.2,2.25,3.31,2.3,1.29,1.31,1.37,1.43,1.76,2.09,2.09,0.61,0.61,0.4,0.18,0.1,0.18,0.27,0.29,0.32,0.29,0.29,0.26,0.26,0.32,0.39,0.36,0.35,0.34,0.43,0.53,0.53,0.46,0.39,0.37,0.35,0.42,0.4,0.37,0.35,0.41,0.48,0.51,0.76,1.36,0.89,0.42,0.42,1.47,1.47,1.41,1.34,0.92,0.51,0.33,0.14,0.2,0.25,0.31,0.27,0.23,0.17,0.12,0.18,0.21,0.22,0.2,0.2,0.2,0.27,0.97,1.66,1.31,0.96,2.82,3.2,3.59,2.7,1.82,1.73,1.64,3.27,4.89,3.88,3.16,2.45,3.0,2.43,1.87,2.22,2.58,1.47,0.36,0.33,0.3,0.27,0.23,0.25,0.26,0.29:1
0.19,0.4,0.6,1.23,1.86,1.6,1.35,0.73,0.1,0.19,0.19,0.14,0.13,0.17,0.18,0.16,0.15,0.16,0.16,0.16,0.18,0.16,0.13,0.11,0.13,0.16,0.13,0.15,0.18,0.17,0.16,0.16,0.16,0.15,0.18,0.18,0.15,0.15,0.19,0.18,0.15,0.14,0.17,0.17,0.16,0.17,0.16,0.14,0.32,0.74,1.19,2.01,2.83,2.56,2.29,1.86,1.44,1.72,2.01,2.82,3.63,2.73,1.83,2.12,2.41,2.7,2.99,2.58,1.85,1.11,1.17,1.19,1.16,1.17,1.21,1.21,1.17,1.17,1.21,1.21,1.18,1.18,1.21,1.2,1.18,1.19,1.2,1.18,1.19,1.2,1.18,1.15,0.85,0.54,0.34,0.13,0.19,0.21,0.16,0.18,0.21,0.2,0.18,0.19,0.2,0.19,0.19,0.19,0.18,0.18,0.21,0.2,0.16,0.15,0.17,0.2,0.16,0.18,0.21,0.2,0.18,0.18,0.2,0.19,0.19,0.19,0.18,0.18,0.21,0.2,0.16,0.17,0.21,0.21,0.16,0.17,0.21,0.2,0.18,0.19,1.17,2.15,1.98,1.81:1
0.21,0.23,0.22,0.21,0.24,0.27,0.26,0.24,0.19,0.23,0.26,0.24,0.22,0.25,0.22,0.19,0.19,0.19,0.19,0.19,0.21,0.23,0.25,0.28,0.31,0.3,0.28,0.25,0.2,0.14,0.17,0.19,0.19,0.19,0.19,0.23,0.26,0.2,0.2,0.2,0.34,1.2,2.07,2.01,1.93,1.86,1.85,1.83,1.79,2.2,2.61,2.61,1.37,1.37,1.27,1.92,2.56,1.94,1.32,1.25,1.19,1.2,1.2,1.19,1.14,1.08,0.64,0.2,0.2,0.21,0.26,0.22,0.17,0.17,0.16,0.18,0.21,0.24,0.27,0.28,0.28,0.28,0.3,0.23,0.16,0.16,0.16,0.16,0.18,0.19,0.19,0.21,0.22,0.23,0.22,0.22,0.22,0.23,0.24,0.21,0.21,0.22,0.22,0.21,0.2,0.2,0.28,0.32,0.36,0.31,0.26,0.31,0.36,0.54,0.72,0.96,1.21,0.91,0.61,0.38,0.14,0.2,0.2,0.19,0.2,0.21,0.23,0.24,0.22,0.26,0.31,0.33,0.38,0.43,0.43,0.26,0.26,0.25,0.23,0.23,0.22,0.22,0.22,0.22:1
0.11,0.18,0.25,0.54,0.83,1.03,1.22,1.32,0.76,0.19,0.23,0.27,0.18,0.18,0.18,0.18,0.18,0.16,0.15,0.16,0.16,0.18,0.21,0.23,0.25,0.23,0.22,0.21,0.2,0.19,0.18,0.18,0.18,0.16,0.16,0.18,0.2,0.21,0.23,0.25,0.29,0.53,0.77,0.61,0.45,0.64,0.83,1.04,1.25,1.22,0.86,0.49,0.42,0.36,0.3,0.25,0.29,0.33,0.32,0.31,0.35,0.4,0.36,0.32,0.29,0.26,0.27,0.48,0.69,1.02,1.34,1.12,0.9,0.6,0.29,0.26,0.31,0.36,0.38,0.4,0.31,0.41,0.5,0.46,0.41,0.39,0.39,0.39,0.4,0.31,0.38,0.44,0.39,0.34,0.37,0.4,0.43,0.47,0.45,0.43,0.42,0.4,0.39,0.37,0.38,0.39,0.38,0.38,0.42,0.41,0.4,0.53,0.67,0.67,2.78,2.78,2.22,1.66,0.92,0.17,0.21,0.5,0.79,1.22,1.22,3.19,3.19,3.03,2.87,2.87,2.96,2.96,2.96,2.71,2.71,2.71,2.15,2.15,1.59,1.03,1.27,1.5,1.44,1.37:1
0.19,0.24,0.29,0.31,0.27,0.23,0.26,0.27,0.25,0.22,0.25,0.32,0.31,0.25,0.22,0.26,0.28,0.25,0.23,0.27,0.31,0.29,0.25,0.23,0.26,0.27,0.26,0.25,0.28,0.3,0.28,0.25,0.23,0.25,0.26,0.28,0.27,0.28,0.28,0.27,0.26,0.22,0.24,0.27,0.3,0.28,0.26,0.26,0.31,0.56,0.8,1.07,1.35,1.36,1.32,1.07,0.73,0.33,0.25,0.2,0.24,0.3,0.3,0.25,0.21,0.26,0.27,0.24,0.21,0.25,0.3,0.29,0.23,0.22,0.25,0.27,0.24,0.23,0.27,0.3,0.27,0.24,0.22,0.25,0.26,0.26,0.26,0.27,0.29,0.27,0.25,0.22,0.24,0.26,0.28,0.28,0.26,0.26,0.3,0.27,0.24,0.24,0.28,0.31,0.28,0.23,0.23,0.23,0.22,0.2,0.24,0.29,0.31,0.25,0.23,0.26,0.39,0.57,0.92,1.27,1.35,1.41,1.41,0.25,0.25,0.26,0.25,0.23,0.26,0.31,0.29,0.25,0.23,0.25,0.26,0.27,0.25,0.27,0.3,0.3,0.26,0.23,0.24,0.29:1
0.19,0.22,0.25,0.19,0.14,0.11,0.2,0.28,0.23,0.19,0.2,0.21,0.2,0.18,0.18,0.19,0.19,0.18,0.16,0.14,0.12,0.17,0.22,0.22,0.24,0.24,0.28,0.2,0.12,0.56,1.0,1.11,1.22,0.71,0.2,0.2,0.2,0.17,0.14,0.17,0.2,1.26,2.33,1.32,0.32,0.72,1.1,1.47,1.4,1.34,1.37,1.38,1.39,1.39,1.42,1.42,1.46,1.42,1.38,1.31,0.98,0.65,0.49,0.32,0.38,0.44,0.4,0.36,0.35,0.44,0.53,0.4,0.27,0.25,0.28,0.31,0.25,0.19,0.19,0.19,0.35,0.35,0.35,0.35,0.35,0.42,0.48,0.44,0.4,0.39,0.41,0.44,0.38,0.32,0.39,0.39,0.39,0.31,0.24,0.82,1.39,1.3,1.21,1.23,1.26,1.3,1.31,1.31,1.29,0.97,0.65,0.44,0.23,0.21,0.2,0.33,0.46,0.41,0.35,0.27,0.19,0.21,0.23,0.55,0.88,0.6,0.32,1.5,2.68,2.38,2.08,2.72,1.86,1.0,0.97,0.95,0.98,1.0,0.7,0.4,0.86,1.33,1.29,1.24:1
1.78,1.59,1.39,1.45,1.45,1.41,1.4,1.45,1.46,1.4,0.85,0.3,0.34,0.38,0.33,0.33,0.39,0.35,0.31,0.31,0.35,0.38,0.38,0.33,0.33,0.38,0.39,0.35,0.33,0.36,0.38,0.37,0.34,0.34,0.37,0.37,0.35,0.35,0.37,0.38,0.36,0.35,0.36,0.36,0.36,0.35,0.37,0.37,0.35,0.34,0.36,0.38,0.37,0.39,0.41,1.08,1.75,1.68,1.66,1.65,1.5,1.34,1.55,1.75,1.68,1.6,1.48,1.41,1.38,1.33,1.31,1.34,1.39,1.4,1.39,1.38,1.14,0.89,0.56,0.22,0.27,0.29,0.27,0.27,0.29,0.28,0.27,0.27,0.3,0.3,0.31,0.33,0.36,0.38,0.35,0.3,0.3,0.31,0.3,0.25,0.26,0.31,0.32,0.27,0.24,0.26,0.27,0.28,0.29,0.33,0.39,0.37,0.31,0.27,0.28,0.29,0.29,0.24,0.25,0.3,0.3,0.26,0.25,0.28,0.31,0.3,0.31,0.34,0.36,0.35,0.32,0.31,0.32,0.84,1.36,1.36,1.4,0.81,0.23,0.27,0.29,0.28,0.27,0.27:1
0.36,0.29,0.25,0.24,0.28,0.27,0.26,0.22,0.86,1.5,1.45,1.37,1.3,0.99,0.69,0.45,0.22,0.24,0.28,0.27,0.25,0.23,0.27,0.33,0.35,0.32,0.28,0.24,0.26,0.27,0.23,0.25,0.29,0.3,0.26,0.23,0.24,0.27,0.3,0.29,0.32,0.34,0.33,0.27,0.24,0.26,0.29,0.31,0.25,0.24,0.29,0.3,0.28,0.28,0.31,0.37,0.34,0.27,0.24,0.28,0.3,0.28,0.26,0.26,0.29,0.29,0.26,0.25,0.29,0.35,0.35,0.31,0.27,0.28,0.31,0.64,1.06,1.34,1.36,1.39,1.08,0.76,0.56,0.35,0.36,0.33,0.3,0.29,0.29,0.28,0.26,0.27,0.28,0.29,0.27,0.26,0.28,0.31,0.34,0.33,0.32,0.3,0.3,0.27,0.25,0.26,0.29,0.29,0.25,0.26,0.28,0.3,0.57,0.83,1.06,1.3,1.89,2.48,1.9,1.31,1.52,1.75,1.91,1.92,1.9,1.86,1.76,1.63,1.55,1.47,1.37,1.28,1.32,1.35,1.36,0.79,0.22,0.31,0.27,0.23,0.24,0.29,0.34,0.38:1
0.38,0.39,0.39,0.38,0.46,0.4,0.35,0.36,0.38,0.33,0.28,0.32,0.37,0.32,0.28,0.32,0.36,0.37,0.38,0.4,0.42,0.38,0.34,0.33,0.33,0.33,0.33,0.32,0.31,0.85,1.39,1.22,1.06,0.74,0.43,0.42,0.41,0.42,0.94,1.45,1.86,2.28,2.13,1.99,1.95,1.91,1.87,1.87,1.87,1.87,1.86,1.85,1.84,1.74,1.47,1.19,1.19,1.2,1.21,1.2,1.18,1.2,1.23,1.06,0.9,0.59,0.27,0.23,0.19,0.19,0.19,0.19,0.2,0.19,0.17,0.19,0.21,0.22,0.22,0.26,0.3,0.25,0.21,0.23,0.19,0.15,0.18,0.22,0.19,0.16,0.18,0.2,0.21,0.23,0.24,0.25,0.26,0.27,0.22,0.16,0.23,0.24,0.25,0.2,0.15,0.18,0.22,0.23,0.23,0.26,0.29,0.26,0.22,0.18,0.26,0.34,0.35,0.37,1.21,2.06,2.32,2.59,2.18,1.78,1.83,1.78,1.74,3.86,2.52,1.18,1.76,2.33,1.72,1.1,1.07,1.07,1.0,0.99,0.99,0.94,0.89,0.93,0.97,0.97:1
1.7,1.5,1.3,3.4,5.5,4.15,2.8,2.67,2.53,2.49,2.45,2.41,1.64,0.88,0.53,0.19,0.17,0.16,0.16,0.22,0.29,0.19,0.14,0.15,0.21,0.26,0.26,0.22,0.21,0.24,0.26,0.29,0.22,0.17,0.13,0.19,0.24,0.16,0.13,0.17,0.21,0.26,0.3,0.99,1.67,1.52,1.36,1.38,1.38,1.39,1.41,1.38,1.35,1.34,1.33,1.33,1.31,1.3,0.89,0.49,0.31,0.14,0.2,0.23,0.22,0.23,0.28,0.31,0.3,0.28,0.34,0.41,0.34,0.27,0.3,0.3,0.29,0.27,0.62,0.97,0.97,1.31,1.31,1.34,1.38,1.41,1.43,1.46,1.43,1.41,1.04,0.66,0.47,0.28,0.26,0.27,0.27,0.23,0.24,0.26,0.28,0.3,0.33,0.65,0.98,0.75,0.51,0.64,0.48,0.31,1.46,2.6,1.44,0.27,0.35,0.44,0.46,0.47,0.48,1.01,1.54,1.75,1.97,1.89,1.81,1.67,1.54,1.49,1.43,1.41,1.43,1.44,1.53,1.61,1.62,1.61,1.6,1.59,1.55,1.0,0.55,0.37,0.37,0.36:1
3.49,3.49,1.63,1.63,1.49,1.35,1.36,0.95,0.53,0.6,0.66,1.06,1.45,1.35,0.85,0.35,0.29,0.3,0.31,0.31,0.32,0.34,0.32,0.32,0.32,0.3,0.28,0.3,0.33,0.33,0.33,0.34,0.34,0.34,0.32,0.32,0.3,0.27,0.29,0.31,0.3,0.29,0.26,0.24,0.31,0.37,0.32,1.14,1.96,1.76,1.57,1.59,1.61,1.63,1.65,2.62,3.59,2.62,1.66,1.57,1.47,1.42,1.38,1.38,1.38,1.52,1.52,5.01,5.01,4.29,3.56,2.69,1.83,1.75,2.49,3.23,3.57,3.91,3.01,2.43,1.86,1.86,2.68,3.5,2.52,1.54,1.51,1.51,1.52,1.46,1.46,2.19,2.19,1.82,1.45,1.41,1.38,1.37,1.35,1.37,1.39,1.36,1.33,1.35,1.37,1.34,1.3,1.33,1.36,1.36,1.29,1.29,1.34,1.38,1.3,1.17,1.04,0.64,0.24,0.24,0.28,0.28,1.01,1.74,1.71,1.67,1.46,1.64,1.81,2.17,2.17,1.34,1.34,0.8,0.26,0.3,0.34,0.3,0.26,0.28,0.3,0.32,0.33,0.23:1
0.18,0.19,0.18,0.16,0.2,0.29,0.6,0.91,1.22,0.85,0.48,0.29,0.11,0.16,0.19,0.18,0.14,0.14,0.22,0.21,0.2,0.21,0.24,0.22,0.16,0.13,0.17,0.19,0.18,0.13,0.15,0.19,0.2,0.19,0.2,0.26,0.22,0.17,0.53,0.88,1.59,2.27,2.27,2.02,2.02,1.95,1.91,1.87,1.8,1.72,2.16,2.59,2.01,1.42,1.3,1.22,1.22,1.76,2.3,2.3,1.3,1.3,1.22,1.17,1.14,1.09,1.03,0.6,0.18,0.21,0.2,0.16,0.13,0.15,0.17,0.18,0.13,0.15,0.19,0.19,0.17,0.19,0.25,0.26,0.22,0.16,0.19,0.22,0.18,0.16,0.16,0.19,0.18,0.16,0.14,0.16,0.2,0.22,0.23,0.23,0.24,0.21,0.19,0.16,0.17,0.18,0.2,0.17,0.15,0.16,0.19,0.19,0.16,0.22,0.29,0.44,0.58,0.93,1.27,1.28,1.27,1.25,1.81,2.38,2.28,2.18,2.51,2.84,2.67,2.57,2.54,2.64,2.73,2.64,2.41,2.19,2.23,2.15,2.07,2.06,2.06,1.57,1.57,1.29:1
1.3,1.42,1.44,1.37,1.0,0.63,0.44,0.3,0.26,0.26,0.29,0.3,0.3,0.28,0.28,0.33,0.37,0.37,0.28,0.27,0.31,0.31,0.27,0.25,0.28,0.31,0.3,0.28,0.27,0.33,0.38,0.37,0.31,0.26,0.27,0.29,0.29,0.24,0.26,0.36,1.22,2.08,2.14,2.2,2.31,2.48,2.68,2.87,2.21,1.54,1.45,1.38,1.62,1.86,1.9,1.89,1.83,1.83,1.86,1.81,1.7,1.59,1.58,1.59,1.61,1.54,1.54,1.58,1.61,1.58,1.55,1.56,1.94,2.32,1.43,0.55,0.47,0.42,0.64,0.86,1.13,1.41,1.48,1.45,1.39,1.32,0.94,0.56,0.42,0.33,0.32,0.34,0.33,0.28,0.25,0.29,0.33,0.31,0.27,0.27,0.31,0.34,0.34,0.35,0.34,0.33,0.3,0.29,0.29,0.33,0.35,0.37,0.46,0.55,0.62,0.64,0.85,1.06,1.13,1.2,0.87,1.3,1.73,2.05,2.38,4.41,3.35,2.29,2.29,1.1,1.1,1.22,1.34,1.18,1.02,1.11,1.2,0.98,0.76,0.52,0.3,0.28,0.29,0.32:1
0.4,0.31,0.3,0.33,0.34,0.28,0.27,0.3,0.29,0.27,0.26,0.28,0.31,0.32,0.3,0.32,0.37,0.36,0.3,0.27,0.28,0.29,0.28,0.26,0.28,0.28,0.27,0.26,0.28,0.28,0.27,0.26,0.31,0.36,0.35,0.29,0.27,0.31,0.35,1.44,2.52,2.41,2.3,2.28,2.27,2.35,2.24,2.14,2.08,1.77,1.46,1.42,1.36,1.32,1.32,1.34,1.33,1.33,1.34,1.33,1.33,1.33,1.36,1.36,1.33,1.37,1.42,1.44,1.39,1.33,1.3,1.34,1.38,1.32,1.3,0.87,0.44,0.28,0.37,0.46,1.05,1.65,1.69,1.59,1.5,1.45,1.39,1.38,1.39,1.41,1.4,1.39,0.86,0.33,0.29,0.29,0.32,0.32,0.31,0.34,0.4,0.38,0.3,0.25,0.25,0.27,0.29,0.33,0.37,0.4,0.37,0.32,0.29,0.81,1.33,1.35,1.41,1.48,1.71,1.94,1.92,1.92,3.02,3.02,2.43,1.84,1.72,1.6,1.46,1.46,3.87,3.87,4.08,4.29,4.23,3.71,3.2,3.2,0.83,0.83,0.6,0.49,0.38,0.47:1
2.52,2.56,2.6,2.61,2.56,2.54,2.53,2.54,2.52,2.52,2.51,2.52,2.53,2.57,2.57,2.58,2.6,2.64,2.62,2.59,2.56,2.54,2.49,2.47,2.48,2.47,2.44,2.45,2.49,2.5,2.48,2.51,2.54,2.51,2.44,2.41,2.43,2.45,2.42,2.44,2.46,2.45,2.41,2.42,2.45,2.46,2.47,2.48,2.47,2.43,2.43,2.44,2.45,2.43,2.39,2.91,3.44,3.48,3.5,3.51,3.01,2.51,2.4,2.48,2.57,2.57,2.58,2.58,2.57,2.57,2.58,2.56,2.55,2.58,2.62,2.65,2.65,2.65,2.61,2.59,2.59,2.64,1.45,0.25,0.41,0.57,0.8,1.23,1.87,2.36,2.68,2.43,2.19,1.73,1.27,1.32,1.35,1.33,1.32,1.36,1.45,1.54,1.6,1.68,1.66,1.63,1.51,1.44,1.45,1.48,1.48,1.45,1.45,1.5,1.27,1.05,0.75,0.45,0.48,0.48,0.43,0.43,0.44,0.42,0.39,0.41,0.44,0.43,0.39,0.4,0.44,0.45,0.43,0.46,0.49,0.48,0.42,0.4,0.46,0.45,0.41,0.4,0.45,0.52:1
0.37,0.31,0.28,0.26,0.26,0.3,0.3,0.26,0.23,0.27,0.31,0.31,0.31,0.28,0.24,0.27,0.3,0.3,0.23,0.23,0.29,0.34,0.29,0.23,0.26,0.3,0.27,0.24,0.24,0.24,0.24,1.25,1.25,1.04,0.84,0.62,0.39,0.29,0.45,0.61,1.91,3.21,2.59,1.98,1.85,1.72,1.3,0.87,0.87,1.71,1.65,1.65,1.47,1.29,1.35,1.4,1.53,1.66,1.94,1.94,1.36,1.36,1.57,1.78,2.47,3.17,2.26,1.35,1.36,1.37,1.37,1.35,1.35,1.37,1.39,1.41,1.36,1.31,1.35,1.39,1.35,1.31,1.35,1.39,1.38,1.38,1.28,1.18,0.79,0.39,0.33,0.28,0.39,0.35,0.31,0.28,0.25,0.31,0.36,0.36,0.31,0.31,0.33,0.34,0.26,0.3,0.33,0.37,0.41,0.34,0.28,0.35,0.51,0.67,1.02,1.38,1.83,2.29,2.29,2.34,2.34,2.33,2.32,1.89,1.65,1.42,1.31,1.2,1.2,1.23,1.26,1.27,1.29,1.25,1.22,1.26,0.93,0.59,0.53,0.46,0.39,0.32,0.32,0.32:1
0.3,0.32,0.34,0.37,0.57,0.77,1.02,1.27,1.25,0.74,0.23,0.29,0.34,0.35,0.35,0.29,0.24,0.29,0.31,0.32,0.28,0.25,0.3,0.36,0.34,0.31,0.29,0.3,0.31,0.33,0.32,0.3,0.3,0.29,0.33,0.35,0.37,0.92,1.48,1.48,1.47,1.37,1.25,1.12,1.0,0.88,1.13,1.38,1.35,1.32,1.42,1.59,1.76,1.6,1.44,1.11,0.77,0.73,0.8,0.86,0.82,0.79,0.72,0.74,0.77,0.81,0.85,0.81,0.78,0.83,0.88,0.92,0.55,0.96,1.38,0.96,0.54,0.43,0.36,0.28,0.35,0.35,0.32,0.32,0.3,0.29,0.29,0.26,0.26,0.25,0.24,0.26,0.29,0.31,0.32,0.31,0.3,0.3,0.31,0.26,0.22,0.65,1.08,1.17,1.25,0.98,0.68,0.37,0.34,0.28,0.22,0.27,0.31,0.36,0.22,0.45,0.67,0.55,0.44,0.58,0.73,0.58,0.43,0.67,0.92,0.92,3.09,3.09,2.62,2.15,2.1,2.06,2.35,1.9,1.46,1.35,1.16,0.97,0.66,0.36,0.33,0.3,0.3,0.31:1
0.44,0.4,0.36,0.35,0.35,0.38,0.36,0.35,0.35,0.38,0.38,0.38,0.42,0.45,0.43,0.37,0.66,1.13,1.35,1.09,0.75,0.41,0.37,0.33,0.33,0.4,0.4,0.39,0.4,0.43,0.4,0.35,0.31,0.33,0.33,0.33,0.3,0.3,0.33,0.36,1.1,1.83,1.93,2.04,2.04,1.93,1.93,1.53,1.36,1.19,2.25,3.31,3.08,2.85,2.04,1.24,1.26,1.29,1.31,1.34,1.79,2.25,1.73,1.21,1.12,0.97,0.82,0.47,0.11,0.16,0.22,0.62,0.82,0.63,0.35,0.3,0.22,0.17,0.27,0.21,0.15,0.16,0.22,0.31,0.48,0.65,1.01,1.36,0.92,0.52,0.23,0.21,0.19,0.16,0.16,0.17,0.17,0.17,0.18,0.18,0.16,0.19,0.25,0.28,0.26,0.23,0.21,0.2,0.18,0.14,0.25,0.37,0.58,0.7,0.74,0.56,0.38,0.32,0.3,0.32,0.31,0.31,0.85,1.4,1.82,2.24,2.29,2.34,2.38,2.38,1.23,1.23,1.18,1.14,0.77,0.4,0.33,0.29,0.28,0.24,0.22,0.23,0.25,0.25:1
0.68,0.66,0.64,0.55,0.45,0.34,0.22,0.3,0.38,0.3,0.21,0.25,0.28,0.31,0.35,0.26,0.37,0.48,0.38,0.28,0.17,0.19,0.22,0.23,0.2,0.16,0.22,0.29,0.3,0.3,0.74,1.18,0.97,0.75,0.45,0.16,0.21,0.26,0.3,0.23,0.16,0.16,0.15,0.22,0.19,0.17,0.19,0.22,0.3,0.24,0.18,0.18,0.18,0.18,0.28,0.28,0.29,0.31,0.3,0.27,1.13,2.0,2.43,2.87,2.12,1.37,2.06,2.74,2.1,1.46,1.41,1.41,1.4,1.37,1.37,2.14,2.14,2.14,2.42,2.42,2.4,2.39,2.1,2.27,2.45,2.2,1.94,2.33,2.33,1.3,1.3,1.04,0.78,0.74,0.69,1.67,2.64,1.65,0.65,0.62,0.87,1.13,1.22,1.32,1.31,1.32,1.05,0.79,0.49,0.2,0.18,0.17,0.17,0.18,0.2,0.22,1.05,1.89,1.41,0.92,0.84,0.77,0.66,0.55,0.48,0.41,0.37,0.34,0.5,0.66,1.28,1.28,2.29,2.29,2.24,2.18,1.8,1.42,1.03,0.63,0.78,0.92,0.78,0.64:1
1.84,1.71,1.58,1.46,1.38,1.36,1.07,0.78,0.51,0.24,0.3,0.3,0.26,0.26,0.31,0.36,0.35,0.31,0.3,0.3,0.28,0.26,0.27,0.28,0.28,0.27,0.28,0.28,0.31,0.32,0.34,0.33,0.29,0.27,0.27,0.3,0.28,0.26,0.25,1.73,3.22,3.17,2.89,2.61,2.47,2.32,1.76,1.6,1.45,1.46,1.65,1.83,1.64,1.44,1.35,1.3,1.29,1.37,1.46,1.37,1.37,1.39,1.33,1.28,1.29,1.32,1.35,1.34,1.31,1.32,1.11,0.91,0.6,0.29,0.3,0.29,0.26,0.26,0.28,0.28,0.28,0.28,0.3,0.29,0.27,0.28,0.35,0.8,1.25,0.85,0.45,0.36,0.28,0.24,0.23,0.27,0.32,0.25,0.24,0.7,0.96,0.64,0.3,0.61,0.91,1.11,1.3,1.2,1.1,0.69,0.27,0.46,0.58,0.64,0.64,1.96,1.96,1.64,1.32,1.06,0.72,0.37,0.34,0.36,0.39,0.39,0.39,3.04,3.04,2.85,2.69,2.54,2.5,2.45,2.1,1.74,1.61,1.49,1.43,1.38,1.37,1.41,1.42,1.4:1
0.29,0.28,0.28,0.25,0.23,0.25,0.28,0.26,0.24,0.25,0.25,0.28,0.25,0.22,0.24,0.27,0.27,0.26,0.23,0.2,0.24,0.28,0.28,0.26,0.26,0.28,0.26,0.24,0.22,0.25,0.27,0.24,0.22,0.23,0.24,0.71,1.18,1.23,0.93,0.63,0.29,1.05,1.81,1.81,0.87,0.87,1.12,1.38,1.53,1.53,2.01,2.01,1.73,1.44,1.4,1.36,1.33,1.31,1.92,2.53,1.89,1.26,1.27,1.29,1.31,1.32,1.23,1.29,1.35,1.32,1.29,1.09,0.9,0.59,0.27,0.25,0.22,0.23,0.25,0.27,0.25,0.23,0.25,0.28,0.26,0.25,0.24,0.24,0.3,0.24,0.18,0.23,0.27,0.26,0.25,0.22,0.18,0.24,0.3,0.23,0.23,0.23,0.25,0.27,0.25,0.22,0.25,0.26,0.27,0.24,0.24,0.29,0.29,0.28,0.25,0.22,0.19,0.2,0.21,0.2,0.18,0.18,0.78,1.39,1.74,2.09,2.16,2.74,3.32,3.32,1.94,1.94,1.83,1.65,1.47,1.49,1.82,2.14,2.45,2.76,3.35,3.08,2.8,2.67:1
0.29,0.25,0.19,0.14,0.17,0.2,0.19,0.18,0.21,0.26,0.26,0.23,0.2,0.19,0.18,0.18,0.16,0.17,0.18,0.19,0.16,0.16,0.19,0.23,0.23,0.23,0.26,0.25,0.19,0.15,0.17,0.19,0.17,0.14,0.16,0.2,0.2,0.79,1.39,1.76,2.13,2.01,1.87,1.73,1.79,1.79,1.66,1.45,1.27,1.18,1.16,1.2,1.22,1.2,1.19,1.24,1.28,1.27,0.9,0.52,0.34,0.19,0.18,0.2,0.23,0.2,0.14,0.14,0.19,0.2,0.17,0.17,0.25,0.26,0.23,0.18,0.17,0.16,0.16,0.11,0.22,0.33,0.49,0.66,0.66,2.25,2.25,2.25,0.6,0.6,0.57,0.55,0.57,1.98,3.24,2.86,2.21,1.97,1.73,1.49,1.25,1.8,2.35,3.22,4.09,3.29,2.48,2.13,1.78,1.43,1.26,0.75,0.24,0.3,0.56,0.82,0.44,0.59,0.74,1.3,1.74,1.74,1.46,1.46,2.95,2.95,3.0,3.05,3.05,0.68,0.68,0.69,0.71,0.73,0.73,0.7,0.66,0.63,0.57,0.39,0.2,0.2,0.17,0.13:1
0.32,0.32,0.32,0.28,0.25,0.32,0.39,0.31,0.22,0.29,0.35,0.81,1.26,1.4,1.19,0.98,0.6,0.23,0.29,0.34,0.29,0.23,0.29,0.27,0.24,0.29,0.33,0.33,0.32,0.32,0.32,0.32,0.28,0.24,0.27,0.3,0.3,0.29,0.32,0.34,0.45,1.35,2.25,2.14,2.03,2.02,2.02,1.8,1.58,1.59,1.47,1.34,1.35,1.34,1.33,1.35,1.36,1.36,1.3,1.3,1.37,1.44,1.4,1.37,1.42,1.48,1.26,1.03,0.8,0.57,0.47,0.37,0.37,0.37,0.87,1.36,0.89,0.42,0.37,0.36,0.34,0.34,0.44,0.44,0.44,0.36,0.36,0.36,0.36,0.35,0.91,1.47,1.4,1.34,1.82,2.3,2.09,1.87,1.82,1.77,1.74,1.7,1.72,1.74,1.73,1.71,2.65,3.59,3.76,3.92,3.62,3.31,2.94,2.58,2.41,2.24,1.9,3.33,4.77,4.47,4.91,5.35,4.03,4.03,2.32,2.32,2.78,3.24,2.95,2.66,2.14,1.62,1.95,2.27,3.36,4.46,3.46,2.46,2.39,2.29,2.18,1.98,3.23,4.49:2
0.84,2.78,3.96,5.14,3.93,2.71,3.08,3.45,2.87,2.3,2.38,2.43,2.42,2.4,2.39,2.39,2.38,2.37,2.38,2.38,2.35,2.34,2.35,2.35,2.37,2.38,2.39,2.35,2.31,2.32,2.33,2.34,2.36,2.34,2.34,2.35,2.34,2.32,2.32,2.34,2.37,2.41,2.38,2.36,2.33,2.31,2.29,2.31,2.31,2.31,2.29,2.45,2.61,3.01,3.41,3.41,2.02,2.02,2.27,2.13,1.98,1.9,1.86,1.87,1.9,1.9,1.88,1.86,1.93,1.99,1.95,2.6,3.25,3.9,4.56,4.06,3.65,3.25,2.72,3.59,4.47,5.66,4.47,3.28,2.52,1.76,1.76,1.48,1.48,1.16,0.84,0.63,0.41,0.69,1.04,1.39,2.29,3.19,3.37,3.56,3.7,3.85,3.85,2.08,2.08,2.16,2.37,2.59,2.63,2.68,2.68,2.69,2.56,2.44,2.49,2.52,2.69,2.85,2.91,2.97,2.34,1.7,1.51,1.32,1.14,1.09,1.04,0.72,0.41,0.36,0.35,0.37,0.38,0.38,0.36,0.39,0.44,0.48,0.39,0.39,0.4,0.44,0.81,1.18:2
0.41,0.34,0.29,0.23,0.27,0.32,0.25,0.24,0.28,0.32,0.32,0.29,0.33,0.36,0.31,0.26,0.24,0.27,0.27,0.27,0.28,0.31,0.33,0.31,0.26,0.23,0.24,0.25,0.27,0.25,0.25,0.31,0.37,0.3,0.22,0.23,0.27,0.31,0.25,0.25,0.29,1.96,3.63,2.88,2.13,2.19,1.95,1.71,1.71,1.71,1.6,1.5,1.05,0.6,0.5,0.41,0.37,0.34,0.78,1.21,1.43,1.4,1.37,1.36,1.35,1.32,1.32,1.33,1.33,1.34,1.32,1.31,1.33,1.35,1.32,1.31,1.33,1.37,1.42,1.42,1.42,1.42,1.46,1.47,1.48,1.55,1.32,1.09,0.79,0.48,0.52,0.55,0.56,0.57,0.58,0.56,0.53,0.52,0.55,0.61,0.68,0.69,0.69,0.69,0.7,0.72,1.01,1.3,1.53,1.93,2.33,2.34,2.36,2.36,3.36,3.36,4.49,5.62,5.62,6.04,6.04,4.43,2.81,3.35,3.89,3.35,2.81,2.67,2.54,2.59,2.64,2.78,2.92,2.92,2.36,2.36,2.06,1.76,0.96,0.96,1.36,1.36,0.88,0.39:2
2.85,2.04,1.23,0.95,0.66,0.76,0.85,0.86,0.55,0.24,0.3,0.26,0.22,0.23,0.27,0.25,0.23,0.25,0.27,0.23,0.17,0.18,0.18,0.18,0.19,0.18,0.17,0.18,0.19,0.2,0.23,0.25,0.26,0.2,0.17,0.17,0.18,0.18,0.17,0.17,0.17,0.18,0.19,0.21,0.24,0.26,0.27,0.24,0.19,0.11,0.57,1.03,1.27,1.99,2.7,1.5,0.3,0.5,0.77,1.03,0.95,0.86,0.51,0.16,0.25,0.35,0.37,0.39,0.38,0.36,0.55,0.74,0.66,0.58,0.61,1.21,1.82,2.02,2.22,2.03,1.85,1.9,1.68,1.45,1.5,1.54,1.73,1.91,2.1,1.83,1.56,2.13,2.7,2.87,3.05,2.47,2.05,1.62,1.8,1.98,1.8,1.72,1.64,1.78,1.92,1.87,1.82,2.14,2.46,3.1,3.74,3.1,2.45,2.18,1.56,0.94,0.92,0.95,0.99,1.23,1.46,1.18,0.89,0.86,0.84,1.59,2.34,2.41,2.48,2.04,1.59,2.31,3.03,1.87,0.71,0.75,0.79,0.77,0.78,0.78,1.6,2.42,2.11,1.79:2
1.57,1.47,1.61,1.74,2.1,2.45,2.38,2.0,1.62,1.54,1.42,1.3,1.48,1.67,1.59,1.52,1.65,1.63,1.62,1.38,1.28,1.18,1.42,1.68,1.63,1.58,1.66,1.69,1.73,1.5,1.27,1.28,1.38,1.48,1.49,1.43,1.36,1.33,1.29,1.29,1.39,1.48,1.88,2.28,3.43,4.58,4.58,4.35,4.35,3.91,3.46,3.46,3.4,3.33,3.2,3.23,3.26,3.49,3.36,3.24,2.9,2.74,2.58,2.76,2.95,2.12,1.29,1.45,1.61,1.62,1.62,1.81,2.0,2.27,3.14,4.01,3.07,2.25,1.42,1.48,1.51,1.57,1.63,1.76,1.89,1.69,1.5,1.51,1.49,2.15,2.8,2.8,2.35,2.35,2.53,2.7,2.69,2.7,2.71,2.71,2.71,2.63,2.17,1.71,1.62,1.54,1.8,2.06,2.17,2.14,2.11,2.23,2.35,2.35,2.19,2.19,1.99,1.78,1.69,2.13,2.56,2.86,3.17,3.26,3.26,1.69,1.69,1.72,1.68,1.56,1.39,1.22,1.08,0.98,0.88,0.93,0.87,0.82,0.81,0.94,1.07,1.22,1.37,1.38:2
0.71,0.49,0.27,0.31,0.36,0.43,0.42,0.4,0.31,0.27,0.22,0.24,0.26,0.27,0.3,0.34,0.3,0.25,0.28,0.27,0.25,0.25,0.27,0.25,0.23,0.23,0.71,1.2,1.26,1.31,1.12,0.68,0.25,0.27,0.29,0.24,0.23,0.3,0.38,0.29,1.42,2.55,2.58,2.38,2.19,2.43,2.68,2.23,1.78,2.2,2.61,1.51,0.41,0.36,0.3,0.41,0.75,1.09,0.77,0.44,0.46,0.48,0.42,0.35,0.37,0.39,0.47,0.52,0.56,0.71,0.85,0.77,1.51,2.25,2.03,1.81,2.39,1.59,0.79,0.84,0.88,0.91,1.1,1.29,1.59,1.88,1.89,1.94,1.98,2.02,1.69,1.37,0.98,0.59,0.47,0.35,0.8,1.24,1.69,1.85,1.91,1.97,1.98,2.0,2.03,2.99,3.96,3.59,3.22,3.1,3.11,3.12,2.98,2.81,2.54,2.27,1.87,1.69,1.51,1.56,1.61,1.52,1.43,1.42,1.41,1.48,1.54,1.48,1.41,1.38,1.35,1.04,0.73,0.68,0.63,0.98,1.33,1.03,0.73,0.45,0.38,0.3,0.28,0.27:2
2.19,1.91,1.63,0.99,0.34,0.29,0.29,0.3,0.3,0.27,0.25,0.27,0.28,0.28,0.27,0.27,0.3,0.3,0.26,0.22,0.23,0.24,0.26,0.28,0.28,0.38,0.38,0.31,0.23,0.23,0.23,0.27,0.31,0.31,0.28,0.28,0.3,0.31,0.57,0.83,1.6,2.13,2.65,2.67,2.69,2.73,2.76,2.78,2.86,2.95,2.33,1.7,2.11,1.92,1.73,1.51,1.28,1.37,1.4,1.43,1.43,1.36,1.36,1.35,1.33,1.29,1.29,1.4,1.4,1.48,1.57,1.89,1.88,1.88,1.86,1.85,1.72,1.58,1.47,1.36,1.49,1.62,2.3,2.99,3.01,2.23,1.44,1.47,1.49,1.6,1.96,2.33,2.33,0.33,0.33,0.26,0.28,0.3,0.29,0.28,0.28,1.63,1.63,1.86,2.09,2.06,2.02,2.02,2.73,2.73,2.47,2.21,2.14,2.01,1.87,2.24,2.61,3.02,3.42,3.3,3.18,2.93,2.69,2.64,2.08,1.53,1.48,1.48,4.78,4.78,4.35,4.03,3.7,2.99,2.29,1.54,0.94,0.35,0.25,0.58,0.9,0.8,0.71,0.69:2
0.54,0.44,0.49,0.54,0.5,0.46,0.44,0.46,0.49,0.48,0.43,0.44,0.52,0.47,0.43,0.44,0.49,0.45,0.42,0.42,0.46,0.5,0.5,0.47,0.47,0.49,0.48,0.43,0.42,0.47,0.52,0.5,0.48,0.5,0.67,0.84,1.2,1.55,1.67,1.77,1.85,2.43,3.0,2.46,1.93,2.07,2.21,2.18,2.2,2.21,2.22,2.96,3.71,4.0,2.84,1.68,1.76,2.18,2.6,2.24,1.87,1.79,1.74,1.69,1.64,1.61,1.61,1.63,1.59,1.55,1.5,1.49,1.5,1.5,1.5,1.53,1.56,1.54,1.5,1.49,1.52,1.52,1.5,1.52,1.58,1.6,1.61,1.54,1.47,1.42,1.37,1.34,1.07,0.7,0.38,0.3,0.26,0.28,0.31,0.3,0.23,0.68,1.13,1.49,1.63,1.76,2.04,1.87,1.69,1.74,1.8,1.85,1.91,1.85,1.8,1.92,2.04,2.54,3.03,3.89,4.74,5.02,5.29,4.63,3.98,3.59,3.2,3.02,2.84,2.71,2.58,3.13,3.69,4.21,4.74,3.79,2.83,3.2,3.61,2.99,2.38,2.38,3.36,3.36:2
0.19,0.2,0.17,0.19,0.24,0.27,0.22,0.19,0.18,0.49,0.92,1.24,0.86,0.49,0.39,0.29,0.24,0.21,0.2,0.19,0.16,0.16,0.2,0.19,0.14,0.12,0.19,0.25,0.18,0.17,0.17,0.17,0.14,0.18,0.19,0.16,0.17,0.24,0.26,0.2,0.17,0.41,0.64,0.5,0.36,0.35,0.35,1.46,1.46,1.93,1.59,1.25,1.29,1.27,1.17,1.07,0.59,0.11,0.17,0.25,0.26,0.2,0.17,0.17,0.16,0.16,0.18,0.16,0.49,0.82,0.6,0.39,0.31,0.56,0.81,1.1,1.38,1.35,1.37,1.14,0.9,0.65,0.4,0.28,0.17,0.14,0.18,0.19,0.17,0.17,0.18,0.21,0.24,0.26,0.2,0.17,0.19,0.2,0.16,0.15,0.2,0.21,0.19,0.22,0.26,0.23,0.18,0.17,0.22,0.26,0.29,2.31,4.33,3.41,2.5,2.83,2.48,2.12,2.4,2.69,1.7,0.72,1.18,1.65,1.65,1.89,1.89,2.12,2.35,1.83,1.31,2.41,3.51,3.51,2.91,2.91,2.96,3.02,2.13,1.31,0.49,0.38,0.33,0.34:2
0.28,0.34,0.39,0.4,0.36,0.33,0.28,0.22,0.24,0.26,0.26,0.25,0.3,0.86,1.41,1.2,0.98,0.64,0.3,0.3,0.31,0.33,0.33,0.31,0.28,0.25,0.25,0.27,0.29,0.27,0.26,0.29,0.33,0.28,0.22,0.3,0.26,0.23,0.25,0.28,0.28,2.36,2.36,2.16,1.97,1.93,2.0,2.07,1.74,1.56,1.37,1.41,1.4,1.39,1.4,1.41,1.42,1.43,1.46,1.48,1.44,1.38,1.35,1.33,1.27,1.2,0.72,0.25,0.34,0.35,0.35,0.39,0.43,0.46,0.49,0.47,0.45,0.53,1.65,2.78,1.63,0.49,0.56,0.53,0.49,1.19,1.89,1.17,0.46,0.43,0.4,0.4,0.4,0.34,0.33,0.33,0.32,0.34,0.37,0.39,0.39,3.3,3.3,3.13,2.95,2.95,1.64,1.64,1.57,1.75,1.93,2.71,3.49,4.68,5.87,5.47,5.07,4.62,4.62,1.8,1.8,1.9,2.15,2.41,3.47,4.54,3.46,2.38,2.81,3.24,2.53,1.82,1.71,1.58,1.31,1.03,1.03,1.46,1.46,1.44,1.42,0.87,0.32,0.23:2
0.26,0.28,0.31,0.29,0.27,0.27,0.28,0.28,0.28,0.3,0.32,0.31,0.32,0.32,0.3,0.28,0.3,0.32,0.28,0.24,0.27,0.31,0.23,0.84,1.46,1.15,0.85,0.62,0.4,0.37,0.3,0.23,0.27,0.31,0.27,0.3,0.32,0.31,0.3,1.22,2.14,2.38,2.62,2.36,2.04,1.72,2.06,2.4,2.68,2.3,1.91,2.34,2.52,2.7,2.04,1.38,1.46,1.42,1.37,1.37,2.17,2.17,1.74,1.32,1.36,1.41,1.35,1.33,1.32,1.38,1.38,1.31,1.38,1.38,1.35,1.33,1.35,1.37,1.51,1.66,1.39,1.12,1.62,2.12,2.05,1.98,1.78,1.59,1.4,1.4,1.44,1.4,1.4,1.41,1.42,1.45,0.85,0.26,0.65,1.04,1.27,1.5,1.6,1.7,1.73,1.75,1.76,1.93,2.09,2.31,2.52,2.6,2.68,2.52,2.75,2.98,2.95,2.91,2.91,3.27,3.27,3.18,3.09,3.1,3.1,3.09,2.75,2.41,2.38,1.78,1.17,1.03,0.82,0.61,0.52,0.43,0.39,0.36,0.35,0.35,0.33,0.31,0.34,0.37:2
1.34,1.48,1.12,0.76,0.55,0.34,0.32,0.27,0.23,0.27,0.32,0.31,0.31,0.31,0.31,0.25,0.27,0.3,0.29,0.28,0.27,0.27,0.3,0.33,0.28,0.23,0.25,0.27,0.28,0.32,0.36,0.33,0.33,0.33,0.28,0.27,0.26,0.28,0.29,0.31,0.29,0.27,0.27,0.4,0.4,0.58,0.75,1.23,1.5,1.77,1.73,1.91,2.09,1.8,1.5,1.46,1.42,1.38,1.35,1.34,1.33,1.33,1.33,1.34,1.36,1.62,1.87,1.78,1.69,1.74,1.79,1.75,1.72,1.79,1.8,1.81,1.84,1.91,1.99,2.14,1.89,1.64,1.61,1.68,1.76,1.87,2.65,3.43,4.12,4.82,3.35,1.89,1.89,1.85,1.85,2.43,3.01,2.44,1.87,1.78,1.69,1.73,1.76,1.81,1.86,1.79,1.74,1.74,5.38,5.38,5.64,4.82,3.99,3.77,3.55,3.96,4.37,4.56,4.76,4.48,4.19,4.04,3.62,3.2,2.85,2.5,2.25,2.01,2.37,2.72,3.75,4.78,3.93,3.08,2.51,1.95,1.98,2.18,2.38,2.25,2.12,3.5,4.87,3.59:2
0.27,0.26,0.27,0.28,0.26,0.23,0.42,0.62,0.6,0.59,0.59,0.6,0.6,0.58,0.56,0.55,0.54,0.42,0.29,0.26,0.27,0.28,0.28,0.32,0.32,0.92,1.53,1.53,0.29,0.29,0.26,0.25,0.23,0.25,0.27,0.3,0.26,0.23,0.55,0.88,0.69,0.51,0.52,0.53,0.62,0.71,1.24,1.78,2.79,2.79,1.7,1.7,1.84,1.85,1.87,1.71,1.54,1.65,1.76,1.75,1.76,1.78,1.75,1.82,1.89,1.8,1.6,1.4,1.36,1.36,1.37,1.41,1.46,2.28,3.09,3.09,1.86,1.86,1.81,1.75,1.79,1.76,1.73,1.63,4.34,7.05,5.46,3.87,3.6,3.32,2.43,1.53,1.53,2.01,2.01,1.74,1.47,1.47,1.4,1.4,1.39,1.38,1.39,1.39,1.39,1.38,1.36,1.38,1.4,1.42,1.67,1.93,2.05,2.17,2.18,2.2,2.21,2.62,3.04,3.65,4.26,4.35,4.45,5.09,5.7,6.32,6.4,4.61,2.83,3.01,3.01,3.84,3.84,4.53,5.21,5.21,2.46,2.46,1.84,1.21,0.93,1.34,1.76,3.1:2
3.58,3.4,3.22,3.15,3.15,2.86,2.86,2.86,0.38,0.38,0.37,0.39,0.41,0.77,1.13,1.13,0.26,0.26,0.26,0.32,0.31,0.33,0.36,0.34,0.33,0.29,0.26,0.31,0.35,0.3,0.26,0.32,0.32,0.32,0.29,0.26,0.28,0.31,0.31,0.34,0.34,0.31,0.28,0.29,0.3,0.3,0.3,0.26,0.53,0.8,1.07,1.34,1.34,0.72,0.72,0.55,0.37,0.42,0.49,0.56,1.05,1.55,2.01,1.92,1.82,1.82,1.75,1.75,1.86,1.97,2.42,2.87,2.76,2.66,2.58,2.5,1.95,1.41,1.16,0.92,0.73,0.54,0.59,0.65,1.08,1.5,1.12,0.73,0.48,0.39,0.31,0.3,0.35,0.39,0.39,0.55,0.71,1.05,1.05,3.15,3.15,2.76,2.36,2.18,1.99,1.99,1.98,1.75,1.52,1.57,1.61,3.0,4.38,4.46,4.53,4.21,3.88,3.31,2.74,3.12,3.5,4.11,4.72,4.2,3.68,3.67,3.16,2.66,2.54,2.42,2.88,3.35,2.4,1.46,1.54,1.63,1.59,1.13,0.67,0.49,0.31,0.27,0.3,0.32:2
0.29,0.34,0.38,0.37,0.32,0.31,0.31,0.3,0.26,0.28,0.3,0.28,0.26,0.29,0.3,0.29,0.27,0.69,1.11,1.2,1.29,0.94,0.59,0.4,0.22,0.29,0.3,0.26,0.27,0.31,0.35,0.34,0.32,0.31,0.29,0.26,0.27,0.28,0.29,0.27,0.28,0.28,0.29,0.28,0.33,0.41,0.48,0.54,0.46,0.38,0.91,1.44,1.65,1.86,2.78,3.7,2.61,1.51,2.14,2.77,2.14,1.51,2.73,3.94,3.83,3.72,3.35,2.98,2.39,1.79,1.78,1.82,1.87,1.85,1.82,1.82,1.82,1.8,1.76,1.75,1.78,1.76,1.69,2.3,2.92,2.26,1.6,1.59,1.57,1.88,2.18,2.19,2.2,2.2,4.38,4.38,3.87,3.3,3.3,0.67,0.67,1.58,2.34,3.09,3.0,2.52,2.03,1.65,1.27,0.9,0.53,0.79,1.05,1.05,2.99,2.99,2.9,2.81,3.02,3.23,2.82,2.41,1.95,1.49,1.81,2.13,2.47,3.04,3.61,3.88,4.15,3.4,2.65,2.7,2.7,3.45,4.2,3.79,3.39,3.43,3.43,2.39,2.39,2.38:2
1.61,1.54,1.55,1.56,1.55,1.54,1.54,1.53,0.99,0.46,0.48,0.51,0.48,0.46,0.52,0.58,0.56,0.53,0.54,0.55,0.5,0.45,0.45,0.46,0.45,0.44,0.44,0.45,0.45,0.45,0.45,0.45,0.46,0.47,0.45,1.98,3.52,3.14,2.77,3.84,4.91,3.42,1.94,2.34,2.74,2.61,2.48,1.27,0.79,0.31,0.31,0.32,0.35,0.34,0.33,0.33,0.34,0.35,0.36,0.39,0.42,0.38,0.34,0.34,0.35,0.3,0.26,0.8,1.34,1.3,1.34,1.38,0.83,0.29,0.32,0.34,0.33,0.33,0.34,0.35,0.36,0.36,0.39,0.39,0.39,0.35,0.31,0.32,0.33,0.3,0.27,0.3,0.34,0.27,0.32,0.38,0.38,0.33,0.27,0.3,0.33,0.35,0.36,0.37,0.37,0.39,0.41,0.41,0.42,0.55,0.69,1.58,2.47,2.93,3.4,3.43,3.47,2.89,2.31,3.55,4.79,3.59,2.39,2.39,2.37,2.37,2.38,2.49,2.59,2.63,2.75,2.87,2.66,2.44,2.12,1.93,1.73,1.71,1.69,1.75,1.81,1.75,1.84,1.93:2
0.59,0.47,0.35,0.3,0.24,0.24,0.31,0.28,0.24,0.24,0.27,0.29,0.31,0.22,0.3,0.37,0.34,0.31,0.31,0.34,0.35,0.32,0.26,0.24,0.31,0.27,0.24,0.23,0.26,0.3,0.3,0.25,0.25,0.29,0.31,0.33,0.31,0.33,0.36,0.38,1.36,2.34,3.13,3.93,3.21,2.49,2.63,2.16,1.7,1.49,1.29,1.34,1.39,1.44,1.44,1.43,1.42,1.39,1.36,1.35,1.36,1.38,1.35,1.35,1.35,1.34,1.32,1.33,1.35,1.38,1.07,0.75,0.58,0.41,0.36,0.34,0.34,0.33,0.3,0.3,0.3,0.3,0.29,0.27,0.27,0.3,0.3,0.28,0.27,0.29,0.33,0.33,0.33,0.35,0.38,0.37,0.31,0.28,0.28,0.29,0.29,0.25,0.24,0.28,0.33,0.27,0.28,0.36,0.34,0.32,1.52,2.73,2.8,2.88,3.22,4.99,6.76,5.26,3.76,3.44,3.11,2.6,2.08,1.61,1.14,1.24,1.45,1.67,1.5,2.55,3.61,4.0,4.45,4.82,3.6,2.39,2.13,1.89,1.89,1.37,1.37,0.83,0.29,0.36:2
1.62,1.44,1.24,1.05,1.15,1.24,1.34,1.2,1.07,1.53,1.99,2.13,2.27,2.29,1.77,1.25,1.19,1.12,1.24,1.36,1.16,1.22,1.27,1.35,1.31,1.26,1.22,1.18,1.15,1.16,1.17,1.18,1.19,1.24,1.25,1.4,1.54,1.81,2.09,1.7,1.32,1.3,1.16,1.03,1.03,1.07,1.11,1.19,1.26,1.37,1.48,1.92,2.36,2.41,2.47,2.34,1.86,1.38,1.74,2.09,2.2,2.25,2.24,2.13,2.01,1.87,1.78,1.69,2.38,3.08,3.07,3.06,3.14,3.21,3.1,2.99,2.33,1.68,1.59,2.01,2.42,2.42,4.11,4.11,3.65,2.66,1.68,1.64,1.56,1.48,1.95,2.41,2.27,1.53,0.8,0.85,1.29,1.73,1.53,1.39,1.21,1.03,0.82,0.61,2.68,4.75,4.18,3.62,3.6,3.58,3.26,2.93,3.04,3.96,4.89,4.8,5.41,6.03,5.29,4.54,3.71,5.01,6.32,7.3,7.28,7.26,6.83,6.41,5.71,5.58,5.45,4.8,4.15,4.15,1.43,1.43,1.4,1.34,1.29,0.89,0.5,0.38,0.3,0.21:2
0.33,0.34,0.36,0.31,0.27,0.28,0.29,0.27,0.24,0.27,0.31,0.31,0.33,0.35,0.35,0.26,0.3,0.3,0.26,0.22,0.27,0.32,0.28,0.25,0.24,0.23,0.27,0.3,0.27,0.25,0.3,0.36,0.29,0.23,0.3,0.44,0.58,0.97,1.35,1.17,0.98,0.65,0.32,0.31,0.29,0.29,2.26,2.26,2.3,2.34,2.41,2.48,2.62,2.84,3.05,2.71,2.36,2.32,2.27,2.5,2.73,2.15,1.57,1.54,1.5,1.54,1.57,1.6,1.64,1.64,1.57,1.55,1.55,1.79,2.03,2.02,2.02,1.96,1.91,1.77,1.64,1.55,1.47,1.42,1.38,1.21,1.04,0.96,0.89,0.98,0.93,0.87,0.9,0.85,0.8,0.82,0.84,0.86,0.87,0.98,1.1,1.13,1.16,1.16,3.45,3.45,3.45,5.29,5.29,4.46,3.93,3.41,3.55,3.69,4.09,4.26,4.43,4.12,3.89,3.67,3.67,3.55,3.55,3.5,3.46,3.41,3.47,3.53,3.49,3.44,3.32,3.19,3.14,3.08,3.09,3.1,3.09,3.09,2.92,2.75,2.99,3.23,4.02,4.81:2
0.39,0.42,0.4,0.38,0.82,1.26,0.78,0.3,0.54,0.92,1.29,1.04,0.68,0.33,0.32,0.32,0.34,0.3,0.26,0.23,0.28,0.33,0.33,0.23,0.23,0.26,0.3,0.28,0.33,0.37,0.37,0.27,0.27,0.28,0.26,0.23,0.23,0.31,0.4,2.03,3.66,2.85,2.04,2.04,1.89,1.74,1.63,1.8,1.96,1.95,1.9,1.85,1.72,1.59,1.56,1.53,1.58,1.77,1.95,1.74,1.53,1.56,1.59,1.69,1.74,1.8,1.78,1.31,0.84,0.84,0.85,0.85,0.75,0.64,0.48,0.32,0.31,0.3,0.28,0.33,0.38,0.42,0.76,1.1,1.77,1.75,1.73,1.75,1.77,1.57,1.38,1.39,1.4,1.52,1.63,1.53,1.42,1.56,1.58,1.61,1.56,1.51,1.51,1.42,1.33,1.38,1.39,1.41,1.4,1.39,1.42,1.46,1.49,2.08,2.66,3.25,3.84,3.36,2.87,2.69,2.51,2.85,3.18,4.28,5.38,5.53,5.69,5.03,4.37,3.6,3.1,2.6,2.46,2.31,2.16,1.84,1.52,1.45,1.38,1.53,1.67,1.09,0.52,0.4:2
0.22,0.29,0.34,0.35,0.32,0.31,0.29,0.28,0.24,0.22,0.27,0.32,0.26,0.26,0.31,0.33,0.33,0.33,0.34,0.33,0.28,0.28,0.29,0.3,0.29,0.28,0.29,0.32,0.33,0.34,0.36,0.4,0.33,0.27,0.28,0.25,0.23,1.44,2.64,2.04,1.44,1.58,1.71,1.61,1.51,1.43,1.35,1.37,1.39,1.32,1.32,1.37,1.34,1.31,1.27,0.99,0.72,0.5,0.29,0.3,0.3,0.28,0.28,0.29,0.31,0.31,0.3,0.3,0.32,0.33,0.35,0.36,0.34,0.28,0.26,0.32,0.3,0.26,0.25,0.28,0.27,0.26,0.27,0.3,0.33,0.37,0.3,0.24,0.34,0.29,0.24,0.26,0.29,0.31,0.29,0.31,0.33,0.36,0.36,0.33,0.31,0.3,0.84,1.37,1.37,1.38,1.06,0.74,1.13,1.52,1.49,1.45,2.12,2.78,4.87,3.56,2.26,3.33,4.4,3.98,3.56,3.65,3.74,2.19,0.64,0.59,0.53,0.51,0.52,0.64,0.76,0.81,1.16,1.5,1.77,2.05,2.08,2.38,2.69,2.23,1.77,1.54,1.31,1.09:2
0.43,0.35,0.27,0.33,0.32,0.3,0.3,0.31,0.31,0.27,0.22,0.25,0.28,0.28,0.28,0.31,0.33,0.39,0.55,0.7,1.05,1.4,0.84,0.28,0.28,0.29,0.3,0.29,0.28,0.3,0.3,0.3,0.28,0.26,0.26,0.26,0.26,0.27,0.28,0.29,0.28,1.36,2.45,2.54,2.59,2.64,2.91,3.17,3.66,4.14,3.77,3.4,2.35,1.3,1.33,1.37,1.38,1.4,1.37,1.35,1.36,1.36,1.29,1.35,1.41,1.35,1.29,1.29,1.37,1.44,0.87,0.31,0.31,0.36,0.36,0.29,0.23,0.31,0.29,0.27,0.27,0.27,0.36,0.45,0.39,0.34,0.34,0.35,0.29,0.3,0.3,0.29,0.28,0.48,0.67,1.01,1.35,1.5,3.3,5.1,3.99,2.89,2.77,2.94,3.11,3.55,3.99,4.27,4.56,4.28,4.0,3.88,3.77,3.64,3.51,3.71,3.91,5.26,6.61,7.14,5.35,3.56,3.48,3.65,3.82,3.37,2.92,2.98,2.98,2.81,2.81,2.42,2.04,1.63,1.22,1.29,1.38,1.35,1.33,1.32,1.31,1.28,1.25,1.21:2
1.31,1.05,0.8,0.75,0.71,0.7,0.69,0.71,0.72,0.74,0.75,0.7,0.66,0.68,0.7,0.64,0.69,0.74,0.7,0.65,0.68,0.7,0.7,0.7,0.7,0.75,0.75,0.72,0.69,0.64,0.67,0.69,0.74,1.09,1.43,0.96,0.49,0.41,0.34,0.34,0.34,0.23,0.23,0.26,0.29,0.23,0.95,1.66,2.23,2.81,2.93,3.05,2.51,1.97,1.69,1.41,1.49,1.57,1.57,1.52,1.47,1.45,1.43,1.5,1.56,1.63,1.7,1.43,1.45,1.46,1.54,1.62,1.48,1.35,0.94,0.54,0.54,0.55,0.55,0.68,0.81,0.81,0.83,0.85,1.15,1.44,1.45,1.46,1.62,1.79,2.33,2.88,2.72,2.13,1.55,0.93,0.31,0.37,0.43,0.97,1.5,1.05,0.6,2.74,4.88,4.03,3.18,3.09,3.0,3.07,3.14,3.15,3.15,3.25,4.55,5.85,6.56,7.27,6.48,5.69,4.6,3.52,3.49,3.19,2.89,2.89,2.95,2.95,2.32,2.0,1.68,1.8,1.75,1.71,1.7,1.69,1.64,1.6,1.64,1.69,1.74,1.79,1.6,1.41:2
0.34,0.3,0.25,0.27,0.34,0.35,0.28,0.26,0.27,0.28,0.26,0.27,0.27,0.27,0.29,0.34,0.34,0.27,0.24,0.27,0.25,0.23,0.23,0.27,0.31,0.32,0.31,0.3,0.29,0.27,0.26,0.27,0.27,0.25,0.25,0.64,1.09,1.39,1.37,0.86,0.35,0.22,1.05,1.89,1.74,1.59,1.57,2.68,3.79,3.41,3.03,2.93,2.82,2.72,2.67,2.96,3.25,2.97,2.42,1.88,2.72,3.56,2.48,1.41,1.37,1.32,1.31,1.33,1.34,1.32,1.36,1.39,1.4,1.37,1.37,1.36,1.33,1.3,1.42,1.54,1.28,1.28,1.19,1.19,1.28,1.37,1.39,1.42,1.42,1.39,1.4,1.39,1.39,1.4,1.46,1.43,1.38,1.38,1.42,1.41,1.31,0.96,0.61,0.89,1.14,1.39,1.33,1.27,0.95,1.06,1.17,1.18,1.96,2.74,2.74,3.71,3.71,3.64,3.57,3.34,3.1,5.06,7.03,5.51,4.0,4.07,4.07,2.29,2.29,2.01,1.77,1.63,1.56,1.55,1.59,1.63,1.64,1.68,1.69,1.65,1.6,1.6,1.61,1.6:2
1.01,1.01,1.01,0.98,0.96,0.92,0.88,1.07,1.26,1.7,1.82,1.93,1.83,2.61,3.4,1.83,0.26,0.3,0.36,0.43,0.94,1.46,0.86,0.26,0.26,0.26,0.2,0.15,0.18,0.21,0.19,0.18,0.13,0.15,0.17,0.28,0.24,0.19,0.18,0.18,0.22,0.26,0.18,0.1,0.16,0.23,0.21,0.16,0.16,0.13,0.28,0.28,0.28,0.16,0.16,0.76,1.36,1.34,1.32,1.33,1.35,1.36,1.37,1.31,1.38,1.46,1.4,1.35,1.36,1.75,2.14,1.57,1.17,0.78,0.73,0.67,0.59,1.67,2.75,2.82,2.37,1.91,2.65,3.39,4.07,3.47,2.87,1.85,0.83,0.81,0.8,0.73,0.66,0.75,0.84,0.84,2.52,2.52,2.57,2.61,1.84,1.37,0.9,0.82,0.74,0.96,1.18,2.81,4.44,4.38,4.32,3.29,3.29,3.04,3.04,3.4,3.38,3.36,2.8,2.24,2.03,1.82,2.02,2.22,2.49,2.42,2.35,2.54,2.72,2.51,2.29,1.64,0.99,0.94,0.89,0.75,0.59,0.43,0.23,0.26,0.29,0.23,0.17,0.12:2
0.99,1.12,1.26,1.02,0.78,0.45,0.12,0.16,0.2,0.24,0.27,0.17,0.15,0.14,0.14,0.19,0.19,0.21,0.23,0.23,0.22,0.2,0.2,0.14,0.14,0.17,0.2,0.21,0.21,0.21,0.19,0.18,0.23,0.17,0.12,0.1,0.17,0.24,0.22,0.2,0.8,1.41,0.91,0.41,0.32,0.31,0.29,0.42,0.41,0.41,0.37,0.41,0.45,0.43,0.41,0.35,0.39,0.44,0.48,0.52,0.52,1.34,1.34,1.43,1.2,0.97,0.68,0.39,0.43,0.42,0.41,0.55,0.69,0.58,0.47,0.47,0.24,0.21,0.21,0.22,0.23,0.18,0.16,0.14,0.18,0.22,0.21,0.2,0.2,0.19,0.19,0.18,0.16,0.18,0.19,0.78,1.37,1.3,1.24,1.24,0.22,0.22,0.22,0.19,0.19,0.36,0.54,0.56,0.57,0.57,2.0,3.44,3.42,3.4,3.01,2.63,2.05,1.47,1.42,1.0,0.58,0.53,0.5,0.46,0.46,0.46,0.46,2.27,2.27,2.29,1.86,1.43,1.26,1.09,1.07,1.05,0.92,0.79,0.85,0.91,0.79,0.67,0.43,0.2:2
0.23,0.24,0.36,0.48,0.9,1.31,1.02,0.72,0.39,0.32,0.24,0.26,0.26,0.26,0.27,0.27,0.28,0.25,0.22,0.24,0.28,0.29,0.3,0.3,0.3,0.31,0.26,0.22,0.22,0.26,0.26,0.26,0.22,0.22,0.27,0.33,0.23,0.48,0.74,0.74,1.33,1.33,1.81,2.29,2.37,2.36,2.34,2.59,2.83,3.24,3.66,2.57,1.48,2.14,2.79,2.08,1.37,1.4,1.44,1.39,1.37,1.41,1.39,1.37,1.37,1.38,1.41,1.43,1.82,2.21,2.48,2.75,2.93,3.12,4.45,5.78,4.97,4.17,4.04,3.91,3.39,3.42,3.45,3.44,3.44,3.64,3.84,3.53,3.22,3.21,3.19,3.16,2.76,2.35,1.55,0.76,0.66,0.56,0.47,0.47,0.48,0.44,0.4,0.73,1.06,1.46,1.86,2.27,2.68,2.96,3.24,3.09,3.04,2.99,2.88,3.11,3.35,2.57,1.79,1.8,1.82,1.85,1.88,2.67,3.45,4.03,4.61,4.72,4.72,3.19,3.19,2.73,2.26,1.95,1.65,1.53,1.42,1.34,1.43,1.51,1.15,1.33,1.51,2.11:2
0.25,0.29,0.27,0.25,0.26,0.25,0.24,0.24,0.27,0.3,0.28,0.26,0.29,0.28,0.28,0.28,0.27,0.25,0.28,0.32,0.33,0.32,0.31,0.31,0.29,0.29,0.28,0.26,0.26,0.26,0.25,0.26,0.26,0.26,0.28,0.29,0.29,0.28,0.27,0.25,1.19,2.12,1.94,2.06,2.18,2.54,2.75,2.96,2.15,1.89,1.64,1.63,1.62,1.61,1.61,1.61,1.6,1.6,1.61,1.6,1.58,1.58,1.58,1.58,0.48,0.48,0.52,0.56,0.56,0.54,0.53,0.53,0.53,0.53,0.51,0.49,0.5,0.51,0.51,0.51,0.56,0.56,0.56,0.56,2.07,2.07,1.29,0.52,0.52,0.52,0.51,0.48,1.17,1.87,1.41,0.95,1.2,1.45,1.4,1.35,1.28,1.22,1.02,0.81,0.84,0.88,0.92,1.19,1.45,1.89,2.34,2.73,3.13,3.17,3.34,3.5,3.19,2.87,2.77,2.68,2.32,1.96,1.76,1.57,1.7,1.84,1.92,2.01,2.25,2.2,2.14,1.88,1.61,1.44,1.26,0.85,0.43,0.34,0.24,0.28,0.28,0.27,0.25,0.23:2
0.32,0.38,0.41,0.37,0.33,0.32,0.33,0.32,0.31,0.32,0.33,0.34,0.34,0.33,0.32,0.29,0.28,0.27,0.28,0.27,0.26,0.26,0.27,0.27,0.27,0.27,0.28,0.29,0.3,0.31,0.32,0.33,0.33,0.45,0.57,0.99,1.41,1.17,0.92,0.83,0.78,0.73,0.69,0.66,1.38,2.11,2.67,2.34,2.01,2.11,2.3,2.5,2.3,2.1,1.79,1.57,1.36,1.38,1.4,1.4,1.36,1.33,1.36,1.44,1.51,1.51,1.5,1.62,1.75,1.63,1.5,1.38,1.35,1.32,1.33,1.36,1.36,1.36,1.38,1.43,1.48,1.53,1.53,2.99,2.99,2.18,1.36,1.4,1.85,2.3,1.92,1.54,1.58,1.54,1.51,1.46,1.41,1.41,1.41,1.37,1.38,1.38,1.36,1.32,1.34,1.35,1.6,1.84,1.93,2.01,1.9,1.78,1.58,1.38,1.53,1.9,2.28,2.45,2.61,2.73,2.84,2.85,2.86,2.78,2.42,2.07,1.96,1.86,1.82,1.82,3.07,3.07,2.87,2.62,2.31,1.92,1.54,1.56,1.61,1.5,1.39,1.38,1.42,1.46:2
0.32,0.28,0.32,0.35,0.33,0.29,0.26,0.27,0.3,0.29,0.26,0.26,0.29,0.32,0.31,0.31,0.31,0.31,0.27,0.26,0.28,0.3,0.29,0.26,0.26,0.31,0.35,0.27,0.26,0.28,0.3,0.27,0.27,0.28,0.3,0.3,0.31,0.34,0.38,0.38,2.52,2.52,2.4,2.29,2.18,2.08,2.04,1.99,1.82,1.56,1.33,1.33,1.32,1.29,1.3,1.3,1.32,1.32,1.32,1.32,1.32,1.32,1.33,1.34,1.33,1.32,1.31,1.34,1.35,1.38,1.42,1.41,1.4,1.34,1.32,1.33,1.35,1.36,1.35,1.34,1.39,1.35,1.31,1.31,1.05,0.8,0.51,0.23,0.29,0.31,0.31,0.3,0.32,0.34,0.31,0.26,0.26,0.31,0.29,0.26,0.24,0.24,0.28,0.32,0.7,1.07,1.4,1.73,1.68,1.62,1.94,2.25,2.39,3.1,3.82,3.69,3.57,3.26,2.95,3.36,3.76,4.57,4.57,3.29,3.29,3.24,3.28,3.33,2.62,1.91,1.81,1.7,1.63,1.55,1.5,1.2,0.9,0.62,0.34,0.26,0.26,0.3,0.31,0.27:2
0.46,0.47,0.46,0.43,0.41,0.41,0.44,0.43,0.42,0.46,0.49,0.48,0.44,0.57,0.69,1.11,1.53,1.33,1.14,0.81,0.48,0.44,0.43,0.46,0.47,0.48,0.47,0.48,0.47,0.46,0.42,0.43,0.47,0.5,0.47,0.46,0.48,0.46,0.43,0.42,0.46,0.45,0.45,0.46,1.53,2.59,1.91,1.23,1.62,2.02,2.63,2.63,3.13,3.13,2.96,2.79,2.73,3.24,3.74,3.99,4.24,4.84,5.43,4.56,3.69,3.11,2.52,3.35,4.19,4.21,4.21,3.51,2.81,2.27,1.72,2.27,2.83,2.34,1.84,1.74,2.24,2.74,2.82,2.58,2.34,1.74,1.74,1.43,1.43,1.35,1.33,1.34,1.34,1.33,1.35,1.37,0.79,0.21,0.23,0.28,0.28,0.27,0.27,0.29,0.27,0.24,0.23,0.26,0.29,0.29,0.27,0.26,0.27,0.24,0.22,0.24,0.27,0.31,0.31,0.25,0.24,0.28,0.28,0.24,0.26,0.35,0.28,0.2,0.22,0.24,0.23,0.22,0.22,0.26,0.26,0.26,0.23,0.25,0.28,0.28,0.26,0.27,0.31,0.32:1
0.21,0.17,0.13,0.09,0.14,0.19,0.19,0.2,0.19,0.17,0.16,0.21,0.25,0.14,0.11,0.08,0.14,0.16,0.18,0.13,0.16,0.19,0.22,0.24,0.25,0.2,0.15,0.12,0.12,0.18,0.18,0.15,0.12,0.13,0.15,0.23,0.32,0.32,0.72,0.72,0.57,0.42,0.97,1.52,1.2,2.25,3.31,2.3,1.29,1.31,1.37,1.43,1.76,2.09,2.09,0.61,0.61,0.4,0.18,0.1,0.18,0.27,0.29,0.32,0.29,0.29,0.26,0.26,0.32,0.39,0.36,0.35,0.34,0.43,0.53,0.53,0.46,0.39,0.37,0.35,0.42,0.4,0.37,0.35,0.41,0.48,0.51,0.76,1.36,0.89,0.42,0.42,1.47,1.47,1.41,1.34,0.92,0.51,0.33,0.14,0.2,0.25,0.31,0.27,0.23,0.17,0.12,0.18,0.21,0.22,0.2,0.2,0.2,0.27,0.97,1.66,1.31,0.96,2.82,3.2,3.59,2.7,1.82,1.73,1.64,3.27,4.89,3.88,3.16,2.45,3.0,2.43,1.87,2.22,2.58,1.47,0.36,0.33,0.3,0.27,0.23,0.25,0.26,0.29:1
0.19,0.2,0.2,0.2,0.22,0.26,0.29,0.28,0.25,0.23,0.21,0.16,0.13,0.17,0.21,0.17,0.17,0.22,0.28,0.2,0.18,0.2,0.2,0.17,0.19,0.21,0.2,0.16,0.75,1.33,0.92,0.52,0.34,0.17,0.18,0.2,0.19,0.18,0.21,0.26,0.25,0.14,0.51,0.88,1.07,1.27,1.66,2.05,1.74,1.74,2.31,2.31,1.78,1.25,1.3,1.31,1.29,2.37,3.45,2.31,1.16,0.73,0.29,0.2,0.17,0.2,0.18,0.15,0.14,0.16,0.18,0.18,0.23,0.2,0.18,0.15,0.16,0.16,0.16,0.15,0.18,0.21,0.21,0.23,0.23,0.22,0.18,0.18,0.17,0.18,0.18,0.21,0.26,0.27,0.27,0.26,0.21,0.2,0.19,0.21,0.18,0.18,0.19,0.22,0.21,0.23,0.25,0.24,0.16,0.16,0.21,0.26,0.71,1.17,1.56,1.55,1.54,1.42,1.31,1.25,1.25,1.21,1.17,0.91,0.65,0.54,0.42,0.33,0.38,0.42,0.39,0.32,0.25,0.23,0.2,0.16,0.12,0.21,0.31,0.21,0.19,0.2,0.19,0.12:1
3.49,3.49,1.63,1.63,1.49,1.35,1.36,0.95,0.53,0.6,0.66,1.06,1.45,1.35,0.85,0.35,0.29,0.3,0.31,0.31,0.32,0.34,0.32,0.32,0.32,0.3,0.28,0.3,0.33,0.33,0.33,0.34,0.34,0.34,0.32,0.32,0.3,0.27,0.29,0.31,0.3,0.29,0.26,0.24,0.31,0.37,0.32,1.14,1.96,1.76,1.57,1.59,1.61,1.63,1.65,2.62,3.59,2.62,1.66,1.57,1.47,1.42,1.38,1.38,1.38,1.52,1.52,5.01,5.01,4.29,3.56,2.69,1.83,1.75,2.49,3.23,3.57,3.91,3.01,2.43,1.86,1.86,2.68,3.5,2.52,1.54,1.51,1.51,1.52,1.46,1.46,2.19,2.19,1.82,1.45,1.41,1.38,1.37,1.35,1.37,1.39,1.36,1.33,1.35,1.37,1.34,1.3,1.33,1.36,1.36,1.29,1.29,1.34,1.38,1.3,1.17,1.04,0.64,0.24,0.24,0.28,0.28,1.01,1.74,1.71,1.67,1.46,1.64,1.81,2.17,2.17,1.34,1.34,0.8,0.26,0.3,0.34,0.3,0.26,0.28,0.3,0.32,0.33,0.23:1
0.18,0.18,0.17,0.2,0.22,0.23,0.2,0.22,0.24,0.28,0.31,0.41,0.34,0.26,0.26,0.35,0.35,0.28,0.21,0.19,0.22,0.25,0.26,0.44,0.61,0.96,1.31,1.34,0.78,0.21,0.19,0.17,0.19,0.21,0.25,0.24,0.23,0.22,0.27,0.33,0.29,0.25,0.21,0.24,0.27,0.29,0.3,0.24,0.22,0.2,0.22,0.25,0.23,0.21,0.18,0.17,0.17,0.24,0.2,0.16,0.14,0.17,0.2,0.25,0.31,0.26,0.21,0.25,0.28,0.3,0.29,0.28,0.28,0.28,0.28,0.33,0.38,0.26,0.14,0.2,0.25,0.22,0.19,0.16,0.14,0.22,0.29,0.42,0.54,0.51,0.52,0.53,1.17,1.81,1.81,1.8,1.79,1.77,1.3,0.83,0.77,0.7,0.97,1.24,1.37,1.5,1.4,1.31,1.03,0.76,0.62,0.49,0.42,0.43,0.44,0.43,0.43,0.41,0.39,0.37,0.4,0.42,0.51,0.47,0.42,0.4,0.39,0.86,1.32,0.86,0.4,0.54,0.69,1.02,0.98,0.94,0.49,0.64,0.8,1.04,1.29,0.94,0.58,0.32:1
0.1,0.2,0.16,0.12,0.14,0.18,0.19,0.17,0.16,0.17,0.18,0.17,0.18,0.19,0.2,0.23,0.23,0.2,0.19,0.2,0.19,0.15,0.15,0.22,0.63,1.03,1.28,1.54,1.49,1.0,0.52,0.49,0.48,0.49,0.9,1.32,1.18,0.86,0.47,0.19,0.17,0.17,0.17,0.16,0.17,0.18,0.16,0.12,0.08,0.04,0.39,0.88,1.34,1.72,2.09,2.37,2.66,2.08,1.51,1.52,1.54,1.47,1.4,1.5,1.55,1.58,1.61,1.62,1.56,1.42,1.28,1.27,1.27,1.27,1.27,1.24,1.22,1.2,1.16,1.16,1.19,1.21,1.18,1.27,1.35,1.47,1.43,1.39,2.4,3.41,2.35,1.29,1.3,1.27,1.22,1.77,2.32,1.73,1.13,1.18,1.17,1.13,0.82,0.48,0.22,0.17,0.15,0.19,0.21,0.19,0.17,0.18,0.18,0.19,0.2,0.19,0.16,0.17,0.21,0.21,0.14,0.17,0.22,0.22,0.17,0.15,0.2,0.2,0.18,0.16,0.18,0.19,0.18,0.18,0.17,0.17,0.18,0.19,0.18,0.17,0.18,0.2,0.17,0.1:1
0.29,0.28,0.28,0.25,0.23,0.25,0.28,0.26,0.24,0.25,0.25,0.28,0.25,0.22,0.24,0.27,0.27,0.26,0.23,0.2,0.24,0.28,0.28,0.26,0.26,0.28,0.26,0.24,0.22,0.25,0.27,0.24,0.22,0.23,0.24,0.71,1.18,1.23,0.93,0.63,0.29,1.05,1.81,1.81,0.87,0.87,1.12,1.38,1.53,1.53,2.01,2.01,1.73,1.44,1.4,1.36,1.33,1.31,1.92,2.53,1.89,1.26,1.27,1.29,1.31,1.32,1.23,1.29,1.35,1.32,1.29,1.09,0.9,0.59,0.27,0.25,0.22,0.23,0.25,0.27,0.25,0.23,0.25,0.28,0.26,0.25,0.24,0.24,0.3,0.24,0.18,0.23,0.27,0.26,0.25,0.22,0.18,0.24,0.3,0.23,0.23,0.23,0.25,0.27,0.25,0.22,0.25,0.26,0.27,0.24,0.24,0.29,0.29,0.28,0.25,0.22,0.19,0.2,0.21,0.2,0.18,0.18,0.78,1.39,1.74,2.09,2.16,2.74,3.32,3.32,1.94,1.94,1.83,1.65,1.47,1.49,1.82,2.14,2.45,2.76,3.35,3.08,2.8,2.67:1
1.72,1.47,1.37,1.26,1.14,0.98,0.62,0.27,0.18,0.16,0.19,0.2,0.18,0.19,0.19,0.18,0.19,0.2,0.18,0.17,0.2,0.18,0.16,0.16,0.2,0.21,0.18,0.17,0.18,0.19,0.19,0.2,0.19,0.16,0.14,0.16,0.19,0.16,0.18,0.21,0.2,0.18,0.18,0.19,0.18,0.19,0.19,0.19,0.2,0.61,1.04,1.32,1.32,1.36,1.49,1.8,2.12,1.76,1.39,1.4,1.39,1.37,1.35,2.18,3.01,3.03,3.05,1.33,1.99,2.64,2.52,2.41,1.84,1.27,1.23,1.2,1.18,1.18,1.21,1.21,1.17,1.17,1.21,1.21,1.17,1.16,1.2,1.2,1.18,1.18,1.19,1.18,1.18,1.19,1.18,1.17,1.2,1.2,1.17,1.16,1.2,1.18,1.15,1.13,0.97,0.81,0.47,0.13,0.16,0.17,0.17,0.18,0.16,0.14,0.15,0.17,0.17,0.13,0.14,0.15,0.16,0.14,0.16,0.19,0.17,0.16,0.16,0.16,0.16,0.18,0.18,0.14,0.15,0.19,0.19,0.14,0.14,0.19,0.19,0.12,0.99,1.87,1.78,1.69:1
0.33,0.3,0.3,0.3,0.29,0.25,0.23,0.26,0.26,0.26,0.23,0.25,0.3,0.32,0.31,0.3,0.32,0.32,0.3,0.25,0.23,0.27,0.26,0.26,0.23,0.25,0.29,0.3,0.27,0.27,0.33,0.32,0.3,0.25,0.25,0.27,0.28,0.26,0.25,0.24,0.48,0.73,1.03,1.33,1.39,1.47,1.47,0.25,0.25,0.28,0.27,0.24,0.25,0.28,0.28,0.25,0.23,0.26,0.29,0.3,0.3,0.31,0.32,0.31,0.27,0.24,0.24,0.29,0.29,0.26,0.22,0.22,0.26,0.3,0.29,0.28,0.3,0.29,0.27,0.23,0.23,0.26,0.25,0.24,0.22,0.24,0.29,0.28,0.25,0.24,0.3,0.36,0.35,0.28,0.24,0.27,0.29,0.27,0.24,0.23,0.25,0.26,0.26,0.26,0.28,0.3,0.33,0.36,0.87,1.38,1.33,1.31,1.3,0.81,0.32,0.25,0.24,0.26,0.28,0.28,0.28,0.31,0.34,0.32,0.26,0.23,0.25,0.29,0.28,0.25,0.23,0.26,0.28,0.28,0.25,0.28,0.37,0.32,0.28,0.24,0.26,0.3,0.29,0.23:1
0.31,0.34,0.38,0.3,0.22,0.27,0.29,0.3,0.27,0.25,0.28,0.32,0.3,0.29,0.31,0.39,0.47,0.86,1.25,0.93,0.61,0.43,0.25,0.3,0.33,0.33,0.31,0.29,0.26,0.28,0.29,0.3,0.29,0.28,0.33,0.39,0.38,1.56,2.75,1.56,0.37,0.49,0.61,0.61,2.36,2.36,1.95,1.54,1.57,2.09,2.61,1.5,0.39,0.44,0.48,0.49,0.49,0.67,0.85,1.08,1.31,1.28,1.25,1.3,0.8,0.3,0.27,0.23,0.3,0.33,0.37,0.31,0.25,0.28,0.28,0.28,0.27,0.27,0.28,0.31,0.3,0.29,0.29,0.28,0.26,0.25,0.26,0.28,0.28,0.31,0.3,0.3,0.33,0.34,0.3,0.28,0.25,0.27,0.29,0.3,0.28,0.26,0.29,0.33,0.37,0.32,0.28,0.28,0.27,0.27,0.2,0.76,1.32,1.34,1.37,1.48,1.6,1.12,0.65,0.54,0.44,2.55,2.69,2.84,3.19,3.53,2.3,1.65,1.0,1.28,1.56,1.92,2.76,3.59,4.04,2.91,1.78,1.12,0.68,0.23,0.25,0.27,0.31,0.34:1
0.68,0.66,0.64,0.55,0.45,0.34,0.22,0.3,0.38,0.3,0.21,0.25,0.28,0.31,0.35,0.26,0.37,0.48,0.38,0.28,0.17,0.19,0.22,0.23,0.2,0.16,0.22,0.29,0.3,0.3,0.74,1.18,0.97,0.75,0.45,0.16,0.21,0.26,0.3,0.23,0.16,0.16,0.15,0.22,0.19,0.17,0.19,0.22,0.3,0.24,0.18,0.18,0.18,0.18,0.28,0.28,0.29,0.31,0.3,0.27,1.13,2.0,2.43,2.87,2.12,1.37,2.06,2.74,2.1,1.46,1.41,1.41,1.4,1.37,1.37,2.14,2.14,2.14,2.42,2.42,2.4,2.39,2.1,2.27,2.45,2.2,1.94,2.33,2.33,1.3,1.3,1.04,0.78,0.74,0.69,1.67,2.64,1.65,0.65,0.62,0.87,1.13,1.22,1.32,1.31,1.32,1.05,0.79,0.49,0.2,0.18,0.17,0.17,0.18,0.2,0.22,1.05,1.89,1.41,0.92,0.84,0.77,0.66,0.55,0.48,0.41,0.37,0.34,0.5,0.66,1.28,1.28,2.29,2.29,2.24,2.18,1.8,1.42,1.03,0.63,0.78,0.92,0.78,0.64:1
1.38,1.33,1.28,1.28,1.29,1.28,1.26,1.24,1.24,1.25,1.26,1.27,1.29,1.3,1.31,1.31,1.08,0.84,0.51,0.19,0.22,0.21,0.2,0.2,0.21,0.24,0.27,0.27,0.28,0.25,0.23,0.21,0.19,0.18,0.17,0.18,0.18,0.24,0.3,0.59,0.87,1.35,1.82,1.44,1.06,0.9,0.9,1.74,1.74,1.67,1.37,1.06,0.51,0.35,0.18,0.21,0.24,0.25,0.26,0.24,0.21,0.2,0.2,0.19,0.18,0.21,0.24,0.59,0.95,0.64,0.33,0.28,0.25,0.23,0.26,0.28,0.23,0.23,0.22,0.21,0.2,0.24,0.28,0.21,0.15,0.23,0.22,0.22,0.22,0.23,0.18,0.13,0.17,0.2,0.16,0.12,0.17,0.22,0.21,0.21,0.26,0.31,0.42,0.53,0.95,1.37,1.86,2.35,1.31,0.26,0.23,0.27,0.3,0.43,0.56,0.49,0.42,0.47,0.51,0.45,0.38,0.82,1.26,2.23,3.21,3.21,3.59,3.59,3.51,3.43,3.43,4.17,4.9,4.03,3.17,3.0,2.77,2.54,1.95,1.35,1.29,0.72,0.16,0.24:1
0.26,0.26,0.28,0.27,0.25,0.23,0.28,0.32,0.31,0.27,0.24,0.27,0.27,0.26,0.24,0.25,0.25,0.26,0.24,0.24,0.26,0.26,0.25,0.25,0.29,0.31,0.29,0.25,0.23,0.25,0.26,0.27,0.27,0.28,0.27,0.27,0.24,0.23,0.25,0.31,0.85,1.38,1.34,1.33,1.34,1.02,0.69,0.5,0.31,0.3,0.26,0.24,0.26,0.27,0.24,0.21,0.24,0.3,0.29,0.25,0.23,0.27,0.26,0.23,0.21,0.22,0.27,0.31,0.24,0.23,0.27,0.27,0.24,0.21,0.23,0.24,0.25,0.22,0.24,0.28,0.28,0.24,0.24,0.28,0.25,0.23,0.21,0.23,0.26,0.28,0.23,0.25,0.31,0.31,0.26,0.22,0.24,0.27,0.26,0.22,0.25,0.29,0.31,0.25,0.23,0.24,0.26,0.27,0.8,1.32,1.35,1.36,1.16,0.96,0.61,0.27,0.26,0.27,0.27,0.28,0.26,0.25,0.23,0.24,0.25,0.27,0.27,0.26,0.27,0.26,0.25,0.23,0.23,0.25,0.28,0.28,0.26,0.26,0.27,0.27,0.23,0.23,0.26,0.3:1
0.32,0.2,0.13,0.15,0.21,0.25,0.21,0.14,0.11,0.13,0.19,0.24,0.17,0.14,0.15,0.19,0.25,0.26,0.25,0.24,0.22,0.23,0.26,0.29,0.26,0.22,0.19,0.23,0.29,0.29,0.24,0.17,0.13,0.34,0.55,0.89,1.22,1.32,1.4,2.32,3.23,2.92,2.15,1.33,1.34,1.35,1.37,1.35,1.34,1.31,1.29,1.27,0.98,0.58,0.27,0.23,0.21,0.24,0.3,0.3,0.25,0.19,0.17,0.2,0.24,0.22,0.16,0.14,0.17,0.21,0.22,0.19,0.18,0.17,0.17,0.18,0.21,0.26,0.28,0.25,0.22,0.23,0.29,0.31,0.28,0.22,0.2,0.25,0.31,0.32,0.25,0.2,0.2,0.23,0.25,0.23,0.17,0.14,0.16,0.21,0.23,0.21,0.18,0.17,0.19,0.2,0.45,0.69,0.69,0.71,0.71,0.51,0.3,0.34,0.31,0.25,0.2,0.23,0.3,0.45,0.61,0.45,0.28,0.31,0.41,0.57,1.0,1.42,1.42,0.98,0.98,0.92,0.86,1.73,2.61,2.61,1.92,1.92,1.33,0.79,0.26,0.31,0.33,0.31:1
0.21,0.2,0.17,0.15,0.19,0.71,1.23,1.79,2.35,1.94,1.54,1.52,1.51,1.33,1.2,0.81,0.42,0.29,0.16,0.2,0.2,0.15,0.16,0.22,0.21,0.15,0.14,0.2,0.21,0.17,0.15,0.18,0.19,0.18,0.17,0.17,0.17,0.17,0.2,0.17,0.16,0.17,0.2,0.17,0.14,0.17,0.19,0.19,0.17,0.19,0.19,0.17,0.15,0.17,0.19,0.17,0.15,1.09,2.03,2.03,0.76,0.76,1.07,1.38,1.57,1.61,1.64,1.66,1.68,1.64,1.57,1.52,1.49,1.42,1.32,1.22,1.2,1.15,1.13,1.17,1.2,1.18,1.16,1.16,1.17,1.16,1.17,1.17,1.15,1.16,1.19,1.2,1.16,1.15,1.19,1.26,0.68,0.1,0.18,0.2,0.17,0.16,0.17,0.18,0.18,0.18,0.18,0.16,0.17,0.2,0.19,0.14,0.16,0.21,0.21,0.15,0.14,0.2,0.2,0.16,0.15,0.18,0.18,0.17,0.17,0.17,0.16,0.17,0.2,0.17,0.15,0.18,0.18,1.1,1.1,1.21,1.67,2.13,2.17,2.2,1.91,1.95,1.99,1.81:1
0.16,0.19,0.18,0.16,0.17,0.19,0.18,0.15,0.18,0.19,0.15,0.53,0.91,1.17,0.85,0.53,0.32,0.11,0.19,0.19,0.15,0.16,0.19,0.18,0.17,0.17,0.18,0.18,0.19,0.17,0.16,0.19,0.18,0.15,0.15,0.18,0.19,0.17,0.17,0.17,0.18,0.24,0.47,0.7,1.08,1.46,2.03,2.6,2.22,1.8,1.47,1.15,1.17,1.17,1.18,1.2,1.18,1.16,1.2,1.19,1.17,1.16,1.19,1.19,1.19,1.19,1.17,1.14,0.87,0.6,0.38,0.16,0.19,0.18,0.16,0.18,0.19,0.19,0.19,0.18,0.18,0.2,0.21,0.16,0.16,0.21,0.21,0.18,0.18,0.19,0.19,0.2,0.19,0.17,0.18,0.18,0.18,0.16,0.19,0.21,0.19,0.18,0.18,0.19,0.19,0.22,0.27,0.35,0.44,0.48,0.34,0.21,0.34,0.72,1.09,1.26,1.43,1.44,1.37,1.3,0.95,0.62,0.29,0.26,0.26,0.26,0.96,0.96,0.96,0.45,0.45,0.39,0.32,0.28,0.25,0.25,1.4,2.55,1.93,1.32,1.25,1.23,1.19,1.09:1
1.31,0.87,0.62,0.38,0.33,0.3,0.28,0.28,0.28,0.27,0.25,0.26,0.27,0.29,0.31,0.31,0.31,0.3,0.28,0.26,0.25,0.26,0.27,0.28,0.27,0.26,0.3,0.34,0.33,0.29,0.25,0.26,0.27,0.27,0.26,0.25,0.27,0.32,1.2,2.07,1.75,1.43,1.49,1.56,1.66,1.71,1.76,1.76,1.71,1.62,1.99,2.37,2.37,1.28,1.28,1.86,2.43,1.87,1.3,1.27,1.28,2.55,3.83,2.63,1.44,1.39,1.37,1.38,1.37,1.36,1.35,1.37,1.44,1.59,2.31,3.04,3.04,3.34,3.34,2.89,2.44,2.38,2.34,2.2,2.05,1.24,0.42,0.48,0.52,0.51,0.46,0.46,0.48,0.5,0.39,0.29,0.34,0.39,0.36,0.28,0.68,1.07,1.29,1.39,1.38,1.31,1.21,0.78,0.35,0.91,1.47,1.62,1.77,1.74,1.56,1.37,1.0,0.63,0.64,0.65,1.01,1.37,1.38,1.69,2.01,2.08,2.12,2.0,1.81,1.81,1.82,1.82,1.25,0.69,1.12,1.55,1.95,2.35,1.75,0.96,0.25,0.25,0.31,0.4:1
0.29,0.3,0.3,0.31,0.3,0.27,0.25,0.26,0.26,0.28,0.27,0.27,0.28,0.3,0.31,0.31,0.3,0.84,1.37,1.11,0.85,0.59,0.32,0.29,0.28,0.29,0.29,0.32,0.34,0.36,0.33,0.31,0.29,0.26,0.26,0.26,0.26,0.26,0.29,0.66,1.04,0.84,0.64,0.73,1.11,1.49,1.62,1.75,1.52,1.29,1.32,1.34,1.33,1.32,1.33,0.8,0.27,0.3,0.32,0.33,0.32,0.29,0.26,0.25,0.27,0.3,0.29,0.25,0.25,0.27,0.31,0.32,0.31,0.31,0.32,0.32,0.28,0.25,0.26,0.3,0.31,0.27,0.24,0.26,0.31,0.35,0.34,0.32,0.31,0.33,0.3,0.26,0.25,0.28,0.32,0.3,0.26,0.24,0.29,0.35,0.65,0.96,1.17,1.38,1.38,0.8,0.22,0.27,0.33,0.4,0.48,0.56,0.59,1.34,2.1,2.73,2.0,1.28,1.22,1.15,0.97,0.79,2.22,3.65,4.38,5.11,4.46,3.75,3.01,3.01,1.61,1.61,1.72,1.84,1.53,1.22,0.94,0.65,0.45,0.34,0.23,0.24,0.32,0.41:1
2.05,2.23,2.42,2.01,1.73,1.44,1.34,1.23,1.16,1.14,1.16,1.17,1.16,1.17,1.16,1.15,1.17,1.2,1.19,0.77,0.38,0.25,0.2,0.15,0.15,0.2,0.19,0.16,0.16,0.18,0.17,0.17,0.18,0.16,0.16,0.18,0.19,0.15,0.15,0.19,0.18,0.15,0.14,0.18,0.19,0.16,0.15,0.17,0.19,0.21,0.32,0.53,0.82,1.24,1.66,1.71,1.76,1.68,2.04,2.4,2.0,1.6,2.54,3.47,3.63,3.78,2.52,1.27,1.32,1.32,1.28,1.3,1.32,1.3,1.26,1.24,1.25,1.24,1.24,1.25,1.27,1.25,1.24,1.26,1.27,1.23,1.24,1.26,1.27,1.22,1.19,0.72,0.25,0.2,0.19,0.2,0.22,0.2,0.21,0.21,0.2,0.2,0.24,0.23,0.21,0.2,0.24,0.24,0.22,0.21,0.22,0.21,0.21,0.22,0.21,0.2,0.22,0.22,0.2,0.2,0.23,0.22,0.18,0.16,0.19,0.22,0.18,0.18,0.2,0.21,0.19,0.21,0.23,0.21,0.19,0.21,0.23,0.21,0.22,0.2,0.2,0.21,0.77,1.32:1
0.49,0.44,0.38,0.4,0.41,0.38,0.35,0.35,0.35,0.35,0.4,0.43,0.42,0.39,0.39,0.36,0.33,0.34,0.35,0.36,0.38,0.38,0.38,0.38,0.41,0.41,0.38,0.36,0.36,0.36,0.38,0.4,0.41,0.43,0.41,0.38,0.36,0.34,0.33,0.32,1.79,3.26,2.38,1.5,1.49,1.55,1.61,1.53,1.45,1.36,1.28,1.33,1.44,1.55,1.66,1.65,1.65,1.62,1.58,1.4,1.21,1.23,1.25,1.25,1.24,1.24,1.25,1.25,1.24,1.23,1.23,1.23,1.1,0.98,0.62,0.26,0.24,0.22,0.2,0.19,0.17,0.14,0.19,0.23,0.22,0.22,0.22,0.21,0.2,0.19,0.18,0.18,0.17,0.19,0.21,0.23,0.26,0.25,0.25,0.4,0.55,0.51,0.47,0.37,0.27,0.26,0.26,0.25,0.26,0.27,0.26,0.25,0.43,0.83,1.22,1.79,2.37,2.12,1.88,1.86,1.94,2.01,2.2,2.39,2.91,3.42,2.83,2.23,1.95,1.66,1.63,2.71,3.78,2.18,0.58,0.57,0.56,0.73,0.91,0.96,1.0,1.07,0.98,0.89:1
0.44,0.4,0.36,0.35,0.35,0.38,0.36,0.35,0.35,0.38,0.38,0.38,0.42,0.45,0.43,0.37,0.66,1.13,1.35,1.09,0.75,0.41,0.37,0.33,0.33,0.4,0.4,0.39,0.4,0.43,0.4,0.35,0.31,0.33,0.33,0.33,0.3,0.3,0.33,0.36,1.1,1.83,1.93,2.04,2.04,1.93,1.93,1.53,1.36,1.19,2.25,3.31,3.08,2.85,2.04,1.24,1.26,1.29,1.31,1.34,1.79,2.25,1.73,1.21,1.12,0.97,0.82,0.47,0.11,0.16,0.22,0.62,0.82,0.63,0.35,0.3,0.22,0.17,0.27,0.21,0.15,0.16,0.22,0.31,0.48,0.65,1.01,1.36,0.92,0.52,0.23,0.21,0.19,0.16,0.16,0.17,0.17,0.17,0.18,0.18,0.16,0.19,0.25,0.28,0.26,0.23,0.21,0.2,0.18,0.14,0.25,0.37,0.58,0.7,0.74,0.56,0.38,0.32,0.3,0.32,0.31,0.31,0.85,1.4,1.82,2.24,2.29,2.34,2.38,2.38,1.23,1.23,1.18,1.14,0.77,0.4,0.33,0.29,0.28,0.24,0.22,0.23,0.25,0.25:1
0.38,0.36,0.33,0.31,0.3,0.28,0.27,0.27,0.29,0.28,0.27,0.26,0.29,0.29,0.27,0.28,0.33,0.38,0.36,0.32,0.32,0.34,0.31,0.25,0.24,0.28,0.3,0.28,0.23,0.26,0.31,0.31,0.25,0.25,0.33,0.33,0.33,0.3,0.32,0.35,0.32,0.26,0.23,0.28,0.31,0.28,0.24,0.26,0.29,0.3,0.26,0.31,0.36,0.38,0.35,0.33,0.34,0.83,1.32,1.32,1.32,1.36,0.81,0.26,0.27,0.29,0.28,0.26,0.27,0.32,0.34,0.34,0.33,0.36,0.36,0.31,0.26,0.28,0.31,0.29,0.24,0.25,0.3,0.31,0.26,0.23,0.28,0.33,0.36,0.31,0.32,0.38,0.36,0.29,0.24,0.25,0.27,0.28,0.23,0.25,0.31,0.31,0.26,0.24,0.29,0.34,0.34,0.32,0.33,0.37,0.35,0.29,0.27,0.28,0.3,0.28,0.26,0.27,0.29,0.28,0.27,0.28,0.29,0.32,0.33,0.35,0.36,0.35,0.32,0.3,0.84,1.38,1.31,1.31,1.37,1.11,0.85,0.57,0.28,0.31,0.31,0.3,0.34,0.42:1
1.3,1.42,1.44,1.37,1.0,0.63,0.44,0.3,0.26,0.26,0.29,0.3,0.3,0.28,0.28,0.33,0.37,0.37,0.28,0.27,0.31,0.31,0.27,0.25,0.28,0.31,0.3,0.28,0.27,0.33,0.38,0.37,0.31,0.26,0.27,0.29,0.29,0.24,0.26,0.36,1.22,2.08,2.14,2.2,2.31,2.48,2.68,2.87,2.21,1.54,1.45,1.38,1.62,1.86,1.9,1.89,1.83,1.83,1.86,1.81,1.7,1.59,1.58,1.59,1.61,1.54,1.54,1.58,1.61,1.58,1.55,1.56,1.94,2.32,1.43,0.55,0.47,0.42,0.64,0.86,1.13,1.41,1.48,1.45,1.39,1.32,0.94,0.56,0.42,0.33,0.32,0.34,0.33,0.28,0.25,0.29,0.33,0.31,0.27,0.27,0.31,0.34,0.34,0.35,0.34,0.33,0.3,0.29,0.29,0.33,0.35,0.37,0.46,0.55,0.62,0.64,0.85,1.06,1.13,1.2,0.87,1.3,1.73,2.05,2.38,4.41,3.35,2.29,2.29,1.1,1.1,1.22,1.34,1.18,1.02,1.11,1.2,0.98,0.76,0.52,0.3,0.28,0.29,0.32:1
0.42,0.32,0.23,0.47,0.7,1.01,1.31,1.3,1.3,0.98,0.55,0.24,0.27,0.29,0.32,0.32,0.31,0.3,0.27,0.25,0.24,0.27,0.29,0.27,0.24,0.25,0.28,0.29,0.27,0.27,0.31,0.3,0.29,0.24,0.22,0.23,0.24,0.24,0.23,0.24,0.28,0.25,0.23,0.23,0.29,0.36,0.35,0.27,0.23,0.26,0.29,0.27,0.23,0.24,0.26,0.28,0.25,0.24,0.27,0.3,0.33,0.3,0.29,0.27,0.26,0.25,0.25,0.28,0.32,0.81,1.3,1.35,1.38,1.07,0.77,0.57,0.38,0.33,0.27,0.23,0.26,0.3,0.3,0.25,0.23,0.23,0.25,0.27,0.24,0.27,0.35,0.3,0.26,0.23,0.24,0.29,0.29,0.25,0.22,0.26,0.29,0.28,0.24,0.25,0.31,0.35,0.33,0.28,0.27,0.27,0.27,0.25,0.26,0.27,0.27,0.26,0.25,0.27,0.27,0.28,0.3,0.32,0.32,0.28,0.24,0.23,0.27,0.29,0.26,0.23,0.25,0.29,0.31,0.47,0.62,1.07,1.51,1.4,1.3,0.88,0.57,0.33,0.27,0.21:1
0.19,0.24,0.26,0.23,0.21,0.2,0.21,0.2,0.17,0.18,0.22,0.26,0.24,0.18,0.17,0.19,0.21,0.18,0.17,0.19,0.24,0.26,0.21,0.19,0.19,0.46,0.72,0.95,1.17,1.27,0.75,0.22,0.18,0.18,0.19,0.2,0.18,0.17,0.2,0.23,0.25,1.96,3.67,2.51,1.36,1.27,1.32,1.37,1.34,0.77,0.2,0.2,0.21,0.21,0.18,0.14,0.17,0.21,0.25,0.21,0.18,0.17,0.18,0.19,0.14,0.15,0.21,0.23,0.22,0.21,0.24,0.27,0.22,0.16,0.15,0.2,0.25,0.3,0.3,0.3,0.32,0.3,0.26,0.25,0.29,0.45,0.61,0.43,0.38,0.32,0.31,0.28,0.26,0.28,0.36,0.79,1.16,1.3,0.99,0.68,0.5,0.33,0.33,0.34,0.27,0.26,0.28,0.31,0.3,0.29,0.32,0.35,0.35,0.27,0.28,0.31,0.37,0.36,0.36,0.5,0.5,0.51,0.36,0.22,1.36,2.51,2.1,2.83,3.56,3.06,2.51,1.93,1.71,1.5,2.13,2.43,1.68,0.73,0.32,0.29,0.25,0.24,0.22,0.2:1
0.2,0.21,0.22,0.22,0.21,0.2,0.2,0.21,0.22,0.21,0.18,0.23,0.28,0.26,0.22,0.18,0.21,0.21,0.2,0.19,0.19,0.2,0.21,0.2,0.21,0.22,0.18,0.14,0.17,0.21,0.24,0.23,0.22,0.19,0.19,0.2,0.22,0.18,0.16,0.68,1.19,0.79,0.38,0.29,0.19,0.19,0.2,0.21,0.23,0.34,0.46,0.36,0.27,0.16,0.94,1.72,1.12,0.53,0.39,0.26,0.17,1.06,1.95,1.96,1.96,1.9,1.84,1.95,2.06,0.68,1.08,1.48,2.16,2.84,2.87,2.9,1.56,0.22,0.29,0.37,0.32,0.27,0.38,0.49,0.63,0.77,0.8,0.82,0.78,0.73,0.6,0.47,0.38,0.28,0.22,0.62,1.02,1.11,1.21,1.19,1.17,0.75,0.33,0.29,0.28,0.28,0.27,0.23,0.31,0.37,0.41,0.43,0.44,0.47,0.67,0.87,0.69,0.51,0.52,1.03,1.53,1.39,1.25,1.49,1.72,2.36,3.0,1.74,0.48,0.75,1.02,1.17,1.26,1.36,1.03,0.7,0.59,0.35,0.12,0.21,0.17,0.14,0.17,0.21:1
0.43,0.33,0.3,0.34,0.36,0.34,0.29,0.29,0.34,0.39,0.39,0.35,0.33,0.35,0.34,0.32,0.28,0.29,0.35,0.35,0.34,0.33,0.36,0.39,0.37,0.32,0.28,0.3,0.35,0.35,0.32,0.29,0.34,0.42,0.4,0.33,0.28,0.3,0.35,0.38,0.96,1.55,1.09,0.63,1.18,1.51,1.84,1.64,1.44,1.39,1.33,1.3,1.32,1.37,1.38,1.36,1.34,1.35,1.37,1.35,1.32,1.3,1.33,1.37,1.36,1.32,1.28,1.06,0.71,0.4,0.33,0.29,0.33,0.36,0.35,0.31,0.3,0.35,0.41,0.42,0.37,0.34,0.34,0.36,0.34,0.31,0.31,0.34,0.36,0.36,0.37,0.38,0.38,0.37,0.34,0.31,0.32,0.34,0.35,0.33,0.32,0.36,0.4,0.41,0.36,0.32,0.33,0.34,0.35,0.34,0.36,0.98,1.61,1.51,1.42,1.33,0.83,0.33,0.31,0.29,0.32,0.35,0.42,0.48,0.54,0.58,0.57,0.55,0.52,0.51,0.5,0.66,0.82,0.71,0.6,0.86,1.12,0.83,0.55,0.87,1.15,1.34,1.37,1.29:1
0.4,0.31,0.3,0.33,0.34,0.28,0.27,0.3,0.29,0.27,0.26,0.28,0.31,0.32,0.3,0.32,0.37,0.36,0.3,0.27,0.28,0.29,0.28,0.26,0.28,0.28,0.27,0.26,0.28,0.28,0.27,0.26,0.31,0.36,0.35,0.29,0.27,0.31,0.35,1.44,2.52,2.41,2.3,2.28,2.27,2.35,2.24,2.14,2.08,1.77,1.46,1.42,1.36,1.32,1.32,1.34,1.33,1.33,1.34,1.33,1.33,1.33,1.36,1.36,1.33,1.37,1.42,1.44,1.39,1.33,1.3,1.34,1.38,1.32,1.3,0.87,0.44,0.28,0.37,0.46,1.05,1.65,1.69,1.59,1.5,1.45,1.39,1.38,1.39,1.41,1.4,1.39,0.86,0.33,0.29,0.29,0.32,0.32,0.31,0.34,0.4,0.38,0.3,0.25,0.25,0.27,0.29,0.33,0.37,0.4,0.37,0.32,0.29,0.81,1.33,1.35,1.41,1.48,1.71,1.94,1.92,1.92,3.02,3.02,2.43,1.84,1.72,1.6,1.46,1.46,3.87,3.87,4.08,4.29,4.23,3.71,3.2,3.2,0.83,0.83,0.6,0.49,0.38,0.47:1
0.37,0.32,0.29,0.3,0.31,0.29,0.26,0.23,0.23,0.23,0.22,0.23,0.23,0.22,0.22,0.23,0.23,0.24,0.28,0.31,0.3,0.28,0.23,0.21,0.19,0.2,0.22,0.23,0.22,0.2,0.18,0.17,0.16,0.2,0.22,0.25,0.27,0.28,0.29,0.29,0.29,0.31,0.97,1.63,1.93,2.22,1.82,1.42,1.57,1.55,1.54,1.46,1.37,1.3,1.29,1.34,1.34,1.32,1.31,1.32,1.28,1.19,0.88,0.57,0.39,0.21,0.21,0.21,0.19,0.21,0.22,0.21,0.18,0.23,0.28,0.27,0.28,0.28,0.25,0.21,0.21,0.2,0.19,0.19,0.19,0.2,0.19,0.19,0.19,0.2,0.23,0.27,0.29,0.27,0.27,0.3,0.31,0.29,0.27,0.24,0.22,0.2,0.2,0.21,0.21,0.2,0.21,0.22,0.25,0.31,0.39,0.46,0.54,0.55,0.55,0.54,0.95,1.37,1.71,1.75,1.79,1.18,0.58,0.54,0.5,0.49,0.44,0.36,0.43,0.49,0.55,0.66,0.74,0.82,0.85,0.88,0.88,0.87,0.85,0.83,0.79,0.57,0.36,0.32:1
0.24,0.29,0.31,0.22,0.22,0.3,0.38,0.34,0.31,0.29,0.28,0.32,0.37,0.3,0.22,0.22,0.28,0.28,0.57,0.85,1.32,0.93,0.55,0.38,0.21,0.3,0.32,0.34,0.31,0.28,0.33,0.38,0.3,0.28,0.27,0.29,0.3,0.33,0.35,1.53,2.71,2.46,2.2,2.2,2.9,2.9,2.3,1.69,2.12,2.55,2.0,1.45,1.37,1.39,1.41,1.4,1.21,1.01,0.65,0.29,0.3,0.31,0.32,0.3,0.29,0.36,0.41,0.46,0.47,0.48,0.44,0.41,0.31,0.22,0.35,0.48,0.4,0.33,0.59,0.92,1.25,1.71,2.17,2.12,2.07,1.98,1.89,1.69,1.48,1.05,0.62,0.48,0.35,0.41,0.39,0.38,0.32,0.33,0.33,0.3,0.27,0.27,0.28,0.28,0.31,0.28,0.28,0.54,0.8,0.8,1.23,1.23,0.88,0.52,0.6,1.09,1.58,2.14,1.43,0.72,0.63,0.53,0.49,0.44,0.47,0.49,1.2,1.91,1.91,3.33,3.33,2.83,2.83,0.58,0.58,0.53,0.46,0.39,0.41,0.43,0.36,0.3,0.3,0.3:1
1.34,1.48,1.12,0.76,0.55,0.34,0.32,0.27,0.23,0.27,0.32,0.31,0.31,0.31,0.31,0.25,0.27,0.3,0.29,0.28,0.27,0.27,0.3,0.33,0.28,0.23,0.25,0.27,0.28,0.32,0.36,0.33,0.33,0.33,0.28,0.27,0.26,0.28,0.29,0.31,0.29,0.27,0.27,0.4,0.4,0.58,0.75,1.23,1.5,1.77,1.73,1.91,2.09,1.8,1.5,1.46,1.42,1.38,1.35,1.34,1.33,1.33,1.33,1.34,1.36,1.62,1.87,1.78,1.69,1.74,1.79,1.75,1.72,1.79,1.8,1.81,1.84,1.91,1.99,2.14,1.89,1.64,1.61,1.68,1.76,1.87,2.65,3.43,4.12,4.82,3.35,1.89,1.89,1.85,1.85,2.43,3.01,2.44,1.87,1.78,1.69,1.73,1.76,1.81,1.86,1.79,1.74,1.74,5.38,5.38,5.64,4.82,3.99,3.77,3.55,3.96,4.37,4.56,4.76,4.48,4.19,4.04,3.62,3.2,2.85,2.5,2.25,2.01,2.37,2.72,3.75,4.78,3.93,3.08,2.51,1.95,1.98,2.18,2.38,2.25,2.12,3.5,4.87,3.59:2
0.32,0.35,0.31,0.31,0.33,0.35,0.3,0.25,0.26,0.26,0.28,0.3,0.28,0.26,0.29,0.32,0.28,0.24,0.3,0.36,0.33,0.31,0.29,0.27,0.28,0.28,0.28,0.28,0.28,0.27,0.26,0.29,0.29,0.29,0.3,0.34,0.37,0.64,0.91,0.91,3.02,3.02,2.64,2.26,2.44,2.78,3.13,3.05,3.55,4.04,3.16,2.28,2.02,1.72,1.42,1.86,2.3,1.82,1.35,1.33,1.31,1.31,1.37,1.37,1.3,1.39,1.48,1.68,1.66,1.64,1.64,2.06,2.48,2.75,3.03,3.03,3.67,3.67,2.88,2.62,2.37,2.36,2.34,2.4,2.46,2.44,2.41,2.42,2.42,2.45,3.62,4.79,4.53,4.28,4.21,3.84,3.48,3.08,2.68,2.6,1.6,0.61,0.61,0.53,0.53,1.09,1.65,1.79,1.94,2.08,2.36,2.53,2.71,2.79,2.86,2.77,2.68,2.68,0.91,0.91,0.81,0.7,0.78,2.24,3.7,3.55,3.6,3.66,3.32,2.98,2.82,2.65,2.65,3.49,3.49,1.96,0.43,0.43,0.38,0.37,0.37,0.35,0.32,0.32:2
1.49,1.29,1.1,0.71,0.33,0.28,0.23,0.27,0.3,0.32,0.33,0.33,0.32,0.3,0.28,0.3,0.29,0.27,0.27,0.27,0.27,0.27,0.27,0.3,0.33,0.34,0.32,0.33,0.33,0.29,0.24,0.27,0.32,0.31,0.3,0.3,0.3,0.26,0.23,0.25,0.31,0.41,0.79,1.18,1.14,1.1,1.5,1.9,2.22,1.96,1.7,1.58,1.62,1.66,1.49,1.32,1.34,1.37,1.37,1.37,1.36,1.36,1.35,1.32,1.28,1.37,1.46,1.42,1.37,2.64,3.91,3.89,2.67,1.46,0.92,0.38,0.39,0.37,0.35,0.37,0.38,0.35,0.32,0.33,0.33,1.42,1.42,0.91,0.4,0.44,0.47,0.42,1.64,2.86,1.57,0.27,0.26,0.3,0.33,0.32,0.31,0.34,0.36,0.36,0.52,0.52,0.57,0.61,0.79,0.96,0.96,2.1,2.1,2.04,1.99,2.79,3.59,4.31,5.02,4.87,4.74,3.54,2.34,2.84,3.34,3.3,3.25,2.96,2.92,2.89,3.13,3.01,2.9,2.88,3.12,3.36,3.36,1.61,1.61,1.41,0.89,0.37,0.71,1.05:2
0.26,0.28,0.31,0.29,0.27,0.27,0.28,0.28,0.28,0.3,0.32,0.31,0.32,0.32,0.3,0.28,0.3,0.32,0.28,0.24,0.27,0.31,0.23,0.84,1.46,1.15,0.85,0.62,0.4,0.37,0.3,0.23,0.27,0.31,0.27,0.3,0.32,0.31,0.3,1.22,2.14,2.38,2.62,2.36,2.04,1.72,2.06,2.4,2.68,2.3,1.91,2.34,2.52,2.7,2.04,1.38,1.46,1.42,1.37,1.37,2.17,2.17,1.74,1.32,1.36,1.41,1.35,1.33,1.32,1.38,1.38,1.31,1.38,1.38,1.35,1.33,1.35,1.37,1.51,1.66,1.39,1.12,1.62,2.12,2.05,1.98,1.78,1.59,1.4,1.4,1.44,1.4,1.4,1.41,1.42,1.45,0.85,0.26,0.65,1.04,1.27,1.5,1.6,1.7,1.73,1.75,1.76,1.93,2.09,2.31,2.52,2.6,2.68,2.52,2.75,2.98,2.95,2.91,2.91,3.27,3.27,3.18,3.09,3.1,3.1,3.09,2.75,2.41,2.38,1.78,1.17,1.03,0.82,0.61,0.52,0.43,0.39,0.36,0.35,0.35,0.33,0.31,0.34,0.37:2
0.38,0.35,0.31,0.28,0.26,0.27,0.28,0.3,0.29,0.29,0.32,0.35,0.31,0.27,0.25,0.26,0.26,0.27,0.28,0.29,0.28,0.28,0.36,0.43,0.88,1.32,0.97,0.63,0.43,0.24,0.25,0.28,0.31,0.28,0.26,0.24,0.28,0.31,0.22,0.73,1.24,0.94,0.63,0.59,0.96,1.33,2.35,2.65,2.95,2.94,2.94,2.32,1.7,1.63,1.56,1.51,1.45,1.51,1.49,1.47,1.46,1.46,1.5,1.54,1.45,1.47,1.51,1.55,1.48,1.42,1.48,1.5,1.51,1.49,1.47,1.48,1.5,1.44,2.19,2.94,3.47,4.0,3.39,2.79,2.79,3.92,3.92,2.88,2.32,1.75,1.68,1.65,1.62,1.6,1.6,1.66,1.75,1.75,2.19,2.19,1.8,1.74,1.69,2.0,2.31,2.49,2.68,2.76,2.84,2.31,1.78,1.76,2.25,2.74,2.61,2.8,3.0,2.92,2.91,2.9,2.97,2.97,2.97,2.95,2.98,3.02,2.77,2.65,2.53,2.49,2.46,1.79,1.13,1.15,1.16,1.99,2.83,2.2,1.58,1.58,0.38,0.38,0.33,0.28:2
0.33,0.42,0.53,0.47,0.4,0.39,0.39,0.36,0.34,0.35,0.35,0.35,0.34,0.37,0.42,0.42,0.39,0.36,0.37,0.33,0.3,0.33,0.37,0.37,0.33,0.32,0.35,0.39,0.42,0.36,0.31,0.33,0.36,0.31,0.29,0.49,0.68,1.09,1.5,1.5,2.08,2.08,1.79,1.5,1.55,1.56,1.51,1.5,1.49,1.43,1.37,1.4,1.39,1.37,1.37,1.38,1.37,1.32,1.3,1.32,1.37,1.37,1.32,1.0,0.68,0.46,0.23,0.71,1.18,1.25,1.32,1.32,1.32,2.11,2.11,1.9,1.69,1.54,1.39,1.44,1.49,1.54,1.59,1.45,2.08,2.71,1.54,0.36,0.38,0.37,0.34,0.74,1.15,0.74,0.33,0.34,0.34,0.31,0.29,0.28,0.3,0.3,0.28,0.27,0.29,0.33,0.36,0.38,0.4,0.38,0.32,0.23,1.07,1.91,2.43,2.96,3.33,3.7,4.14,4.57,4.24,3.54,2.78,2.78,2.78,2.78,3.03,3.3,3.85,4.4,4.4,1.99,1.99,1.83,1.67,1.25,2.0,2.74,1.85,0.96,0.92,0.91,0.91,0.94:2
0.27,0.34,0.35,0.28,0.25,0.29,0.31,0.28,0.25,0.29,0.35,0.35,0.29,0.26,0.3,0.31,0.28,0.26,0.28,0.34,0.34,0.29,0.27,0.3,0.31,0.28,0.26,0.28,0.32,0.33,0.3,0.29,0.29,0.3,0.27,0.27,0.29,0.31,0.33,0.34,0.34,0.32,0.89,1.28,1.11,0.62,1.71,2.79,2.31,1.83,2.01,2.19,1.97,1.76,1.6,1.53,1.51,1.55,1.59,1.57,1.52,1.54,1.62,1.66,1.59,1.54,1.57,1.62,1.6,1.54,1.53,1.61,1.61,0.83,0.83,0.63,0.44,0.39,0.32,0.31,0.35,0.35,0.3,0.28,0.33,0.37,0.38,0.33,0.33,0.36,0.36,0.31,0.28,0.32,0.35,0.36,0.33,0.34,0.36,0.36,0.31,0.29,0.33,0.38,0.52,0.67,0.64,0.86,1.08,1.42,1.77,1.56,1.3,1.09,0.89,1.51,1.93,2.36,3.52,4.67,4.06,3.45,3.1,2.75,2.67,2.55,2.69,2.83,3.23,3.65,3.47,3.29,2.97,2.65,2.48,2.3,1.57,0.84,0.58,0.32,0.3,0.32,0.35,0.36:2
1.01,1.01,1.01,0.98,0.96,0.92,0.88,1.07,1.26,1.7,1.82,1.93,1.83,2.61,3.4,1.83,0.26,0.3,0.36,0.43,0.94,1.46,0.86,0.26,0.26,0.26,0.2,0.15,0.18,0.21,0.19,0.18,0.13,0.15,0.17,0.28,0.24,0.19,0.18,0.18,0.22,0.26,0.18,0.1,0.16,0.23,0.21,0.16,0.16,0.13,0.28,0.28,0.28,0.16,0.16,0.76,1.36,1.34,1.32,1.33,1.35,1.36,1.37,1.31,1.38,1.46,1.4,1.35,1.36,1.75,2.14,1.57,1.17,0.78,0.73,0.67,0.59,1.67,2.75,2.82,2.37,1.91,2.65,3.39,4.07,3.47,2.87,1.85,0.83,0.81,0.8,0.73,0.66,0.75,0.84,0.84,2.52,2.52,2.57,2.61,1.84,1.37,0.9,0.82,0.74,0.96,1.18,2.81,4.44,4.38,4.32,3.29,3.29,3.04,3.04,3.4,3.38,3.36,2.8,2.24,2.03,1.82,2.02,2.22,2.49,2.42,2.35,2.54,2.72,2.51,2.29,1.64,0.99,0.94,0.89,0.75,0.59,0.43,0.23,0.26,0.29,0.23,0.17,0.12:2
0.2,0.26,0.31,0.3,0.29,0.3,0.31,0.31,0.64,0.98,1.3,1.23,1.15,0.68,0.21,0.28,0.34,0.32,0.3,0.3,0.28,0.26,0.22,0.24,0.28,0.25,0.21,0.22,0.23,0.26,0.29,0.21,0.29,0.38,0.35,0.3,0.27,0.24,0.25,0.25,0.25,0.27,0.3,0.27,0.24,0.94,1.63,1.45,1.16,0.87,0.53,1.29,2.06,2.92,3.78,3.23,2.68,2.18,1.68,1.78,1.89,1.94,1.99,2.07,2.15,1.97,1.87,1.77,1.6,1.43,1.52,1.62,1.72,1.81,1.9,1.98,2.05,2.23,2.41,2.24,2.07,1.96,1.85,2.07,2.29,2.29,2.72,2.72,3.02,3.33,3.36,3.4,3.15,2.9,4.38,3.73,3.07,2.83,2.59,2.58,2.58,2.61,2.64,2.56,2.48,2.36,2.24,2.18,2.11,2.37,2.63,2.91,4.26,5.61,5.62,5.41,5.2,4.99,4.78,4.78,4.78,4.78,4.17,3.48,2.78,2.86,2.87,2.87,2.8,2.73,3.27,3.82,4.67,5.52,4.51,3.5,3.87,4.23,4.49,4.75,4.07,3.39,3.42,3.45:2
3.75,4.05,4.35,4.06,3.62,3.18,2.88,2.59,2.54,2.5,2.47,2.43,2.47,2.51,2.46,2.48,2.5,2.48,2.46,2.45,2.45,2.49,2.2,1.91,1.69,1.48,1.43,1.39,1.39,1.4,1.39,1.37,1.38,1.4,1.38,1.36,1.31,1.39,1.46,1.43,1.44,1.44,1.33,1.22,1.3,1.39,1.36,1.33,1.22,1.11,0.99,1.73,2.47,1.99,1.52,1.38,1.56,1.73,2.07,2.41,2.41,3.2,3.2,3.59,3.92,4.25,3.3,2.46,1.61,1.54,1.47,1.44,1.4,1.44,1.43,1.41,2.26,3.1,3.13,3.16,2.58,1.99,1.76,1.53,1.53,1.8,1.8,2.2,2.61,2.06,1.51,1.53,1.55,1.57,1.54,2.27,3.01,2.69,2.38,2.34,2.31,2.03,1.74,1.5,1.25,1.35,1.45,1.92,2.39,2.58,2.77,3.42,4.07,4.18,4.18,5.69,5.69,5.69,5.05,5.05,3.99,2.93,2.35,1.77,1.79,2.01,2.23,2.62,3.02,4.05,3.26,2.48,2.42,2.37,2.28,2.25,2.25,2.23,2.22,1.39,0.55,0.56,0.56,0.44:2
2.37,2.37,2.37,1.9,1.43,1.43,1.44,1.44,1.42,2.24,3.06,2.5,1.95,1.8,1.66,1.69,1.67,1.62,1.56,1.53,1.5,1.09,0.67,0.5,0.33,0.28,0.27,0.31,0.31,0.27,0.26,0.28,0.32,0.33,0.33,0.34,0.38,0.35,0.28,0.26,0.3,0.31,0.27,0.24,0.24,0.98,1.72,2.63,2.82,3.01,2.48,2.12,1.77,1.69,1.62,1.65,1.67,1.68,1.7,1.74,1.78,1.87,1.94,1.96,1.91,1.89,1.91,1.93,1.9,1.82,1.71,1.61,1.51,1.51,1.52,1.33,1.15,1.27,1.4,1.39,1.38,1.39,1.4,1.4,1.4,1.47,1.54,1.54,1.51,1.5,1.49,1.5,1.51,1.49,1.43,1.43,0.33,0.33,0.27,0.3,0.37,0.45,2.27,4.1,4.21,4.32,3.54,2.77,2.65,2.91,3.18,3.21,3.89,4.58,4.23,3.88,3.58,3.29,2.73,2.18,2.11,2.04,2.09,2.14,2.17,2.56,2.95,3.16,3.43,3.7,5.05,6.41,6.32,6.15,5.97,4.15,2.33,2.12,1.97,1.91,2.35,2.79,2.79,2.79:2
0.34,0.31,0.32,0.34,0.33,0.31,0.35,0.39,0.38,0.37,0.34,0.31,0.31,0.31,0.31,0.32,0.32,0.29,0.29,0.32,0.35,0.37,0.37,0.33,0.33,0.29,0.31,0.34,0.32,0.3,0.23,0.77,1.31,1.38,1.07,0.76,0.43,0.68,0.94,1.47,2.89,4.3,3.23,2.16,2.28,2.4,2.22,2.04,1.73,1.43,1.37,1.31,1.38,1.35,1.33,1.35,1.36,1.36,1.36,1.37,1.38,1.01,0.64,0.46,0.28,0.3,0.32,0.32,0.25,0.31,0.29,0.29,0.3,0.3,0.39,0.35,0.31,0.3,0.3,0.3,0.3,0.29,0.28,0.31,0.33,0.32,0.31,0.27,0.32,0.37,0.32,0.31,0.29,0.29,0.31,0.31,0.33,0.34,0.32,0.3,0.32,0.34,0.35,0.37,0.35,0.56,0.78,1.22,1.67,1.66,1.66,1.73,2.01,2.28,2.35,2.41,2.47,2.55,2.64,2.74,2.83,2.66,2.88,3.09,3.47,3.89,4.32,3.59,2.85,2.87,2.77,2.68,2.49,3.14,3.8,3.8,1.43,1.43,1.4,1.37,1.43,0.87,0.31,0.25:2
0.94,1.09,1.07,1.17,1.23,1.39,1.3,1.15,0.99,0.91,0.97,0.98,0.96,0.95,1.01,1.22,1.28,1.24,1.24,1.23,1.39,1.35,1.3,1.29,1.36,1.72,1.87,2.07,1.98,1.94,1.88,1.73,1.38,1.23,1.18,1.06,0.92,0.99,0.87,0.94,0.84,0.85,0.95,0.88,0.94,0.82,0.92,0.9,0.83,0.98,1.32,1.67,1.51,1.38,1.52,1.46,1.4,1.14,1.09,1.11,1.61,2.16,2.72,3.28,2.99,2.7,2.41,2.21,2.2,2.1,2.13,2.01,2.95,3.89,3.1,3.8,4.5,4.67,4.43,3.64,2.81,2.37,2.2,2.32,2.35,2.49,2.48,2.39,2.54,2.47,2.27,1.48,1.99,2.49,2.39,2.06,1.67,1.57,1.45,1.42,1.65,2.02,2.17,2.13,2.21,2.35,2.66,2.77,2.84,2.6,2.62,2.64,2.65,2.67,2.91,3.46,3.58,3.06,2.15,2.01,2.69,3.45,3.85,3.64,3.43,3.07,3.13,3.49,3.09,2.14,1.3,1.01,0.78,0.54,0.37,0.28,0.28,0.29,0.29,0.26,0.27,0.28,0.29,0.28:2
1.34,0.78,0.22,0.26,0.33,0.4,0.32,0.31,0.29,0.29,0.25,0.25,0.27,0.3,0.34,0.33,0.32,0.32,0.33,0.31,0.31,0.25,0.25,0.25,0.29,0.32,0.32,0.35,0.35,0.29,0.29,0.29,0.29,0.32,0.4,0.48,0.92,1.36,1.09,0.78,0.47,0.49,0.51,0.49,0.48,0.47,0.5,0.53,0.56,0.66,0.76,1.01,1.6,2.19,2.03,1.88,1.5,1.12,0.94,0.77,0.98,1.19,1.02,0.85,0.92,1.36,1.79,0.99,1.45,1.9,1.73,1.56,1.41,1.26,1.04,0.82,0.8,1.11,1.41,1.71,1.58,1.44,1.43,1.0,0.58,0.51,0.44,0.44,0.44,0.45,0.45,0.41,0.37,0.41,0.45,1.07,1.69,1.63,1.3,0.98,1.62,2.26,2.02,1.77,1.41,1.04,1.4,1.77,1.74,2.15,2.57,2.36,2.69,3.03,2.94,3.09,3.23,3.22,3.22,2.69,2.16,2.12,2.07,3.16,4.25,4.35,4.44,4.24,4.04,4.0,3.96,3.86,3.75,3.19,2.63,2.16,1.69,1.63,1.78,1.92,1.92,1.34,1.34,1.37:2
3.71,3.72,3.73,3.71,3.69,3.66,3.64,3.6,3.56,3.47,3.41,3.34,3.49,3.49,3.5,3.46,3.43,3.29,2.89,2.48,2.4,2.31,2.29,2.33,2.38,2.29,2.33,2.37,2.26,2.14,2.29,2.36,2.43,2.36,2.26,2.12,2.06,2.0,2.05,2.1,2.11,2.09,2.08,2.12,2.04,1.95,2.01,2.06,2.1,2.1,2.4,2.4,2.1,1.8,1.81,1.32,0.82,0.63,1.05,1.47,1.55,1.56,1.56,1.55,1.55,1.56,1.57,1.57,1.58,1.55,1.53,1.55,1.53,1.5,1.6,1.7,1.67,1.64,1.62,1.62,2.07,2.51,1.61,0.71,2.65,4.58,5.51,4.11,2.72,2.32,1.92,1.85,1.77,2.29,2.81,2.97,3.13,2.58,2.03,2.03,2.16,2.16,2.2,2.25,2.37,2.49,2.6,2.94,3.27,3.56,3.88,3.88,7.16,7.16,7.02,6.88,6.48,6.08,5.07,4.67,4.28,4.08,3.88,3.31,3.17,3.04,3.18,3.32,3.66,4.0,3.98,4.24,4.5,4.29,3.62,2.95,2.38,2.56,2.73,2.56,2.39,2.54,2.7,2.84:2
1.47,1.38,1.33,1.36,1.42,1.43,1.36,1.34,1.39,1.24,1.09,0.7,0.31,0.28,0.28,0.32,0.32,0.3,0.28,0.29,0.27,0.24,0.24,0.24,0.25,0.25,0.3,0.3,0.3,0.26,0.26,0.28,0.27,0.26,0.27,0.26,0.27,0.32,0.32,0.3,1.52,2.74,2.61,2.47,2.22,1.97,2.63,2.63,1.77,1.77,1.52,1.27,1.3,1.31,1.32,1.3,1.34,1.36,1.34,1.37,1.4,1.39,1.32,0.82,0.32,0.26,0.26,0.3,0.3,0.26,0.26,0.34,0.3,0.27,0.26,0.28,0.29,0.28,0.28,0.32,0.45,0.58,0.56,0.54,0.43,0.39,0.43,0.36,0.3,0.3,0.32,0.33,0.33,0.63,0.93,1.15,1.36,1.62,1.87,1.63,1.39,1.42,1.45,1.63,1.8,2.26,2.72,3.03,3.34,3.2,3.06,2.8,3.07,3.33,3.17,2.88,2.59,2.99,3.39,2.9,2.4,2.48,2.82,3.15,3.06,2.96,2.96,2.96,2.81,2.81,2.38,1.93,1.47,1.42,1.36,1.34,1.4,1.46,0.98,0.5,0.44,0.36,0.29,0.23:2
0.41,0.45,0.5,0.44,0.38,0.4,0.43,0.4,0.37,0.43,0.5,0.41,0.32,0.38,0.44,0.38,0.32,0.41,0.49,0.49,0.4,0.4,0.39,0.39,0.41,0.43,0.42,0.41,0.38,0.34,0.91,1.47,1.15,0.75,0.36,0.35,0.34,0.33,0.32,0.33,0.35,0.36,0.36,0.36,0.36,0.34,0.31,0.27,1.3,2.32,1.31,0.3,0.3,0.28,0.42,0.42,0.44,0.45,0.46,0.37,0.29,0.72,1.15,1.3,1.46,1.73,2.64,3.55,2.82,2.08,2.27,2.45,2.53,2.61,2.09,1.57,1.57,3.98,3.98,3.62,3.26,3.05,2.84,2.58,2.32,2.86,3.4,2.51,1.61,1.63,2.18,2.73,2.13,1.53,1.89,2.25,2.22,1.37,0.53,0.44,1.91,3.37,2.66,1.95,1.16,0.75,0.33,0.36,0.39,0.39,0.55,0.55,2.12,3.69,3.53,3.37,3.16,2.95,2.56,2.16,3.25,4.35,4.38,4.42,4.61,4.81,4.53,4.26,3.51,2.75,2.64,2.53,2.05,1.81,1.58,1.51,1.45,1.39,1.34,1.39,1.42,1.42,1.41,1.23:2
0.97,0.7,0.62,0.53,0.42,0.3,0.29,0.27,0.26,0.24,0.25,0.26,0.26,0.27,0.27,0.28,0.36,0.37,0.33,0.31,0.3,0.3,0.28,0.25,0.28,0.31,0.67,1.02,1.36,1.02,0.67,0.49,0.31,0.29,0.26,0.26,0.26,0.84,1.43,2.16,2.89,2.75,2.61,2.27,2.07,1.87,1.69,1.51,1.41,1.31,1.41,1.36,1.32,1.32,1.43,1.43,1.17,0.91,1.22,1.53,1.4,2.39,3.38,2.41,1.45,1.38,1.39,1.41,1.4,1.51,1.61,1.2,0.78,0.58,0.37,0.42,0.43,0.43,0.4,0.4,0.4,0.41,0.41,0.4,0.44,0.48,0.45,0.47,0.5,1.57,2.64,2.4,2.59,2.78,2.81,2.85,2.79,1.59,0.39,0.39,0.41,0.41,0.41,0.4,0.47,0.48,0.49,1.7,2.92,2.41,1.9,1.8,2.12,2.43,3.02,3.62,4.06,3.69,3.33,3.08,3.13,3.18,3.47,3.76,3.45,3.14,2.89,2.65,2.51,2.38,2.37,2.1,1.84,1.43,1.01,0.92,0.84,0.74,0.78,0.83,0.83,0.76,0.7,0.75:2
0.53,0.54,0.52,0.53,0.55,0.57,0.53,0.49,0.48,0.5,0.49,0.48,0.47,0.48,0.52,0.51,0.49,0.48,0.52,0.56,0.56,0.51,0.43,0.34,0.28,0.27,0.3,0.31,0.28,0.26,0.29,0.31,0.29,0.28,0.33,0.89,1.45,1.07,0.71,0.35,0.31,0.26,0.26,0.31,0.31,0.26,0.25,0.3,1.36,2.42,2.42,1.24,1.24,0.92,0.92,1.61,1.61,1.46,1.32,1.36,1.42,1.43,1.4,1.36,1.22,1.08,0.7,0.32,0.4,0.46,0.49,0.51,1.15,1.79,1.76,1.79,1.75,1.72,1.74,1.71,1.67,3.01,4.36,4.55,4.74,4.53,4.33,3.96,3.96,3.76,3.76,3.27,2.47,1.68,1.58,1.69,1.81,2.26,2.71,2.8,2.9,2.86,2.82,2.09,2.35,2.61,2.94,3.28,3.76,4.24,4.69,5.14,5.28,4.78,4.27,4.2,3.23,2.25,2.15,2.04,2.04,2.03,2.59,3.14,3.14,4.01,4.01,3.5,2.98,2.8,2.67,2.59,2.54,2.67,2.8,2.77,2.74,2.18,1.65,1.13,0.84,0.55,0.57,0.57:2
1.26,0.83,0.4,0.31,0.35,0.39,0.37,0.34,0.34,0.34,0.34,0.34,0.33,0.31,0.38,0.44,0.37,0.29,0.33,0.37,0.37,0.38,0.38,0.37,0.35,0.35,0.33,0.32,0.3,0.3,0.31,0.34,0.37,0.37,0.38,0.38,0.38,0.32,0.36,0.39,1.52,2.65,2.63,2.61,2.59,2.58,2.58,2.57,2.1,1.62,1.54,1.46,1.55,1.64,1.64,2.66,2.66,2.04,1.43,1.54,1.96,2.39,1.92,1.45,1.43,1.42,1.4,1.39,1.39,1.47,1.37,1.37,0.99,0.6,0.41,0.4,0.38,0.38,0.38,0.3,0.37,0.45,0.38,0.38,0.38,0.4,0.42,0.36,0.3,0.37,0.34,0.31,0.34,0.37,0.37,0.37,0.35,0.33,0.35,0.37,0.35,0.34,0.68,1.02,1.13,1.13,1.13,1.03,1.21,1.39,1.67,2.1,2.53,2.56,2.59,2.53,2.46,1.95,1.44,1.81,2.18,2.35,2.53,3.44,4.36,4.36,2.27,2.27,2.66,3.05,2.9,2.62,2.35,2.28,2.22,1.32,0.42,0.38,0.34,0.32,0.3,0.23,0.31,0.4:2
0.34,0.28,0.34,0.41,0.48,0.54,0.53,0.41,0.3,0.29,0.3,0.3,0.3,0.28,0.28,0.28,0.28,0.28,0.28,0.28,0.27,0.25,0.39,0.54,0.95,1.37,1.02,0.68,0.51,0.35,0.3,0.3,0.31,0.27,0.23,0.23,0.28,0.27,0.29,0.29,0.3,0.3,0.3,0.22,1.25,2.27,2.25,2.23,2.17,2.11,2.28,2.45,2.22,1.99,1.99,2.65,2.65,2.04,1.42,1.71,2.04,2.37,2.52,2.68,2.97,3.26,3.66,3.68,3.7,3.34,2.73,2.11,1.91,2.34,2.78,2.85,2.93,2.98,3.04,2.94,2.84,2.51,2.18,2.03,1.95,1.88,1.89,1.89,1.97,2.04,2.17,2.31,1.97,1.62,2.15,1.85,1.56,1.5,1.43,1.51,1.58,2.0,2.41,2.41,3.58,3.58,4.06,4.54,4.31,4.29,4.28,4.15,4.47,4.78,3.64,2.51,2.36,2.6,2.85,3.31,3.31,3.32,3.35,3.38,4.01,4.64,4.58,4.52,4.65,4.78,5.03,4.89,4.75,4.14,3.54,3.24,2.94,2.77,2.64,2.69,2.74,2.76,2.93,3.11:2
1.36,1.36,0.26,0.26,0.25,0.23,0.2,0.21,0.21,0.17,0.14,0.16,0.19,0.17,0.14,0.16,0.19,0.18,0.16,0.19,0.25,0.26,0.22,0.21,0.21,0.18,0.15,0.16,0.17,0.18,0.15,0.16,0.17,0.18,0.17,0.22,0.27,0.87,1.46,1.87,2.29,2.26,2.23,2.09,1.95,2.03,1.72,1.41,1.3,1.22,1.19,1.2,1.23,1.24,1.26,1.27,1.27,1.23,1.2,1.19,1.21,1.22,0.69,0.15,0.18,0.17,0.14,0.15,0.2,0.23,0.22,0.22,0.26,0.24,0.17,0.15,0.19,0.19,0.15,0.14,0.18,0.19,0.16,0.13,0.17,0.18,0.18,0.19,0.21,0.22,0.23,0.17,0.16,0.18,0.19,0.13,0.15,0.2,0.19,0.14,0.14,0.18,0.19,0.18,0.2,0.25,0.27,0.23,0.2,0.19,0.18,0.16,0.46,1.5,2.9,3.36,3.4,3.86,4.45,3.61,2.78,3.21,3.64,3.18,2.68,2.39,2.1,2.16,2.21,2.76,3.31,2.62,2.3,1.98,3.12,1.72,0.31,0.3,0.33,0.35,0.33,0.29,0.3,0.35:2
1.93,1.65,1.38,1.46,1.4,1.34,1.36,1.38,1.39,1.19,0.98,0.65,0.32,0.31,0.3,0.29,0.26,0.24,0.27,0.31,0.32,0.33,0.35,0.37,0.35,0.32,0.28,0.23,0.26,0.28,0.29,0.3,0.48,0.66,0.59,0.53,0.57,0.61,0.53,0.44,0.38,0.32,0.31,0.93,1.55,1.1,0.65,0.99,1.32,1.32,3.07,3.07,3.33,3.58,3.2,2.64,2.07,1.74,1.41,1.38,1.34,1.21,1.08,0.67,0.26,0.3,0.31,0.3,0.3,0.29,0.32,0.31,0.3,0.29,0.38,0.46,0.51,0.55,0.58,1.35,2.11,3.28,2.84,2.39,1.8,1.2,1.6,1.99,1.34,0.7,0.83,1.49,2.15,2.11,2.08,2.08,0.35,0.35,0.48,0.62,0.59,0.52,0.46,0.44,0.43,0.45,0.47,0.47,0.4,0.33,1.03,1.72,2.03,2.33,2.55,2.77,2.77,2.75,2.56,2.37,2.05,1.73,1.78,1.83,1.79,1.74,2.59,3.44,3.4,3.35,3.22,3.08,3.48,3.87,3.89,3.91,3.83,4.5,5.18,4.39,3.6,3.66,3.71,3.92:2
0.39,0.35,0.3,0.31,0.32,0.27,0.22,0.24,0.26,0.26,0.26,0.28,0.31,0.31,0.3,0.23,0.27,0.32,0.28,0.24,0.26,0.29,0.32,0.31,0.31,0.31,0.31,0.27,0.23,0.26,0.29,0.32,0.51,0.69,0.69,0.96,0.96,0.6,0.24,0.28,0.97,1.66,1.37,1.08,1.09,1.72,2.34,2.17,2.0,3.04,4.08,3.09,2.09,1.86,1.63,1.53,1.42,2.57,3.73,2.56,1.38,1.39,1.39,1.45,1.52,1.52,1.52,1.55,1.56,1.56,1.56,1.56,1.54,1.53,1.53,1.54,1.53,1.53,1.53,1.53,1.57,1.6,1.63,1.63,0.46,0.46,0.46,0.48,0.48,0.56,0.64,0.64,0.6,0.6,0.54,0.48,0.49,0.51,0.55,0.6,0.49,0.39,0.44,0.69,0.93,1.25,1.58,1.56,1.55,1.62,1.68,2.63,3.57,2.6,1.64,1.59,2.12,2.65,3.28,3.9,3.14,3.45,3.76,4.87,4.81,4.75,4.06,3.37,2.88,2.55,2.23,1.77,1.48,1.19,1.16,1.12,1.12,0.97,0.82,0.55,0.28,0.29,0.31,0.31:2
4.72,4.72,4.72,4.63,4.54,4.07,3.61,3.61,3.46,3.46,3.89,4.33,3.38,2.43,2.43,2.42,2.42,2.41,2.41,2.41,2.4,1.34,0.28,0.32,0.3,0.28,0.32,0.35,0.3,0.25,0.23,0.29,0.34,0.3,0.26,2.01,3.76,3.61,3.46,3.47,3.49,3.41,2.91,2.41,2.41,2.41,2.44,2.45,2.39,4.13,4.13,3.79,3.46,3.46,3.37,3.37,3.38,3.38,3.51,3.64,3.75,3.86,3.7,3.54,3.37,3.76,4.16,2.77,1.39,2.12,2.12,4.41,4.41,3.83,3.24,3.19,3.14,2.92,3.69,4.46,3.62,2.78,2.33,1.89,2.84,3.8,3.59,3.37,3.14,2.9,2.21,1.52,1.47,1.41,1.72,2.02,2.3,2.44,2.59,1.9,1.9,0.4,0.4,1.06,1.72,2.73,3.74,4.29,3.67,3.04,3.05,3.05,3.11,3.21,3.31,4.19,5.07,4.12,3.17,3.09,2.74,2.4,3.16,3.92,3.63,3.35,3.25,3.25,3.28,3.28,2.32,1.35,1.3,1.13,0.95,0.65,0.35,0.39,0.42,0.36,0.38,0.4,0.4,0.4:2
0.39,0.38,0.34,0.29,0.27,0.26,0.24,0.25,0.26,0.82,1.37,1.3,1.16,1.03,0.66,0.29,0.28,0.27,0.27,0.27,0.28,0.3,0.31,0.31,0.28,0.25,0.28,0.31,0.35,0.35,0.3,0.3,0.31,0.27,0.24,0.29,0.28,0.27,0.28,0.3,1.23,2.16,2.08,2.0,2.01,2.01,2.06,2.11,2.18,2.24,2.55,2.86,2.71,2.56,2.38,2.19,2.11,2.02,1.81,1.71,1.61,1.57,1.54,2.61,3.68,3.73,3.27,2.81,2.22,1.63,1.66,1.69,1.69,1.7,1.72,1.59,1.46,1.37,1.38,1.39,1.36,0.82,0.28,0.3,0.31,0.35,0.38,0.38,0.39,0.32,0.26,0.26,0.33,0.27,0.24,0.29,0.37,0.34,0.34,0.4,0.46,0.41,0.36,0.33,0.3,0.27,0.25,0.27,0.3,0.33,0.37,0.69,1.0,2.25,3.51,2.7,3.02,3.33,5.01,3.36,1.72,1.72,1.46,1.46,2.61,3.75,4.26,4.78,4.78,5.86,5.86,5.57,5.28,4.81,4.3,3.79,2.62,1.44,1.44,1.44,1.44,1.44,1.32,1.32:2
0.71,0.49,0.27,0.31,0.36,0.43,0.42,0.4,0.31,0.27,0.22,0.24,0.26,0.27,0.3,0.34,0.3,0.25,0.28,0.27,0.25,0.25,0.27,0.25,0.23,0.23,0.71,1.2,1.26,1.31,1.12,0.68,0.25,0.27,0.29,0.24,0.23,0.3,0.38,0.29,1.42,2.55,2.58,2.38,2.19,2.43,2.68,2.23,1.78,2.2,2.61,1.51,0.41,0.36,0.3,0.41,0.75,1.09,0.77,0.44,0.46,0.48,0.42,0.35,0.37,0.39,0.47,0.52,0.56,0.71,0.85,0.77,1.51,2.25,2.03,1.81,2.39,1.59,0.79,0.84,0.88,0.91,1.1,1.29,1.59,1.88,1.89,1.94,1.98,2.02,1.69,1.37,0.98,0.59,0.47,0.35,0.8,1.24,1.69,1.85,1.91,1.97,1.98,2.0,2.03,2.99,3.96,3.59,3.22,3.1,3.11,3.12,2.98,2.81,2.54,2.27,1.87,1.69,1.51,1.56,1.61,1.52,1.43,1.42,1.41,1.48,1.54,1.48,1.41,1.38,1.35,1.04,0.73,0.68,0.63,0.98,1.33,1.03,0.73,0.45,0.38,0.3,0.28,0.27:2
0.39,0.31,0.26,0.3,0.39,0.38,0.31,0.26,0.29,0.32,0.3,0.26,0.27,0.31,0.32,0.28,0.29,0.35,0.38,0.33,0.28,0.28,0.29,0.29,0.27,0.28,0.29,0.3,0.27,0.3,0.35,0.36,0.31,0.27,0.28,0.32,0.69,1.06,1.4,1.75,1.9,2.06,4.93,7.8,5.55,3.3,2.7,2.1,2.19,2.29,1.85,1.41,1.43,1.41,2.02,2.64,2.01,1.38,1.36,1.39,1.43,1.41,1.36,1.32,1.36,1.39,1.37,1.33,1.34,1.39,1.4,1.38,1.39,0.94,0.48,0.37,0.33,0.35,0.45,0.56,0.69,1.13,1.56,1.51,1.51,1.56,2.3,3.04,3.04,2.29,2.29,2.17,1.88,1.58,1.35,1.36,1.38,1.91,2.45,2.43,3.11,3.79,3.79,2.37,2.37,2.32,2.27,2.27,2.34,2.86,3.38,3.38,4.1,4.1,5.17,6.24,6.24,4.91,4.91,4.66,4.96,5.25,5.14,4.06,2.98,3.25,3.52,3.61,3.7,3.7,2.84,2.84,2.51,2.17,2.99,2.99,0.85,0.85,0.56,0.27,0.28,0.28,0.26,0.26:2
0.41,0.34,0.29,0.23,0.27,0.32,0.25,0.24,0.28,0.32,0.32,0.29,0.33,0.36,0.31,0.26,0.24,0.27,0.27,0.27,0.28,0.31,0.33,0.31,0.26,0.23,0.24,0.25,0.27,0.25,0.25,0.31,0.37,0.3,0.22,0.23,0.27,0.31,0.25,0.25,0.29,1.96,3.63,2.88,2.13,2.19,1.95,1.71,1.71,1.71,1.6,1.5,1.05,0.6,0.5,0.41,0.37,0.34,0.78,1.21,1.43,1.4,1.37,1.36,1.35,1.32,1.32,1.33,1.33,1.34,1.32,1.31,1.33,1.35,1.32,1.31,1.33,1.37,1.42,1.42,1.42,1.42,1.46,1.47,1.48,1.55,1.32,1.09,0.79,0.48,0.52,0.55,0.56,0.57,0.58,0.56,0.53,0.52,0.55,0.61,0.68,0.69,0.69,0.69,0.7,0.72,1.01,1.3,1.53,1.93,2.33,2.34,2.36,2.36,3.36,3.36,4.49,5.62,5.62,6.04,6.04,4.43,2.81,3.35,3.89,3.35,2.81,2.67,2.54,2.59,2.64,2.78,2.92,2.92,2.36,2.36,2.06,1.76,0.96,0.96,1.36,1.36,0.88,0.39:2
1.17,1.48,1.79,2.09,2.4,2.39,2.39,2.44,2.43,2.36,2.33,2.35,2.39,2.38,2.39,2.4,2.41,2.38,2.41,2.44,2.47,2.42,2.4,2.39,2.4,2.39,2.4,2.41,2.41,2.38,2.39,2.38,2.4,2.4,2.43,2.42,2.39,2.37,2.39,2.39,2.36,2.35,2.36,2.36,2.31,2.31,2.35,2.38,2.35,2.33,2.35,2.34,2.3,2.3,2.33,2.33,2.28,2.29,2.4,2.6,2.97,3.35,3.07,2.78,2.78,0.5,0.5,0.34,0.28,0.31,0.37,0.36,0.33,0.34,0.38,0.39,0.36,0.36,0.35,0.34,0.29,0.31,0.34,0.33,0.3,0.32,0.38,0.41,0.43,0.48,0.52,0.49,0.43,0.44,0.46,0.45,0.41,0.44,0.5,0.88,1.3,1.55,1.71,1.87,2.11,2.35,2.39,2.45,2.5,2.52,2.4,2.29,2.23,2.45,2.67,2.67,1.34,1.34,1.38,1.38,1.75,2.12,3.17,4.22,4.15,3.06,1.96,2.08,2.21,2.69,3.17,3.48,3.79,3.06,2.33,2.09,1.86,1.8,1.74,1.68,1.69,1.69,1.7,1.71:2
